document.addEventListener("DOMContentLoaded", function () {
    const menuToggle = document.querySelector(".menu-toggle");
    const navLinks = document.querySelector(".nav-links");
    const searchIcon = document.querySelector(".search-icon");
    const searchContainer = document.querySelector(".search-container");

    // Menu Toggle - Open/Close nav menu
    menuToggle.addEventListener("click", function (event) {
        event.stopPropagation(); 
        navLinks.classList.toggle("show"); 

        // Close search if menu is opened
        searchContainer.classList.remove("active");
    });

    // Search Icon - Open/Close search input
    searchIcon.addEventListener("click", function (event) {
        event.stopPropagation(); 
        searchContainer.classList.toggle("active");

        // Close menu if search is opened
        navLinks.classList.remove("show"); 
    });

    // Close both menu and search when clicking outside
    document.addEventListener("click", function (event) {
        if (!navLinks.contains(event.target) && !menuToggle.contains(event.target)) {
            navLinks.classList.remove("show"); 
        }

        if (!searchContainer.contains(event.target) && !searchIcon.contains(event.target)) {
            searchContainer.classList.remove("active");
        }
    });
});