// JavaScript for Toggle Menu and Search Icon

// Toggle Navigation Menu
const menuToggle = document.querySelector('.menu-toggle');
const navLinks = document.querySelector('.nav-links');

menuToggle.addEventListener('click', () => {
    navLinks.classList.toggle('active'); // Toggle the 'active' class on nav-links
});

// Toggle Search Container
const searchIcon = document.querySelector('.search-icon');
const searchContainer = document.querySelector('.search-container');

searchIcon.addEventListener('click', () => {
    searchContainer.classList.toggle('active'); // Toggle the 'active' class on search-container
});

// Close Search Container When Clicking Outside
document.addEventListener('click', (event) => {
    if (!searchContainer.contains(event.target) && !searchIcon.contains(event.target)) {
        searchContainer.classList.remove('active'); // Close search container if clicked outside
    }
});



// Banner Slideshow Section
let slideIndex = 0;
let slides = document.querySelectorAll(".slide");
let dots = document.querySelectorAll(".dot");

function showSlide(index) {
    if (index >= slides.length) slideIndex = 0;
    if (index < 0) slideIndex = slides.length - 1;

    slides.forEach((slide, i) => {
        slide.style.display = i === slideIndex ? "flex" : "none";
        dots[i].classList.toggle("active", i === slideIndex);
    });
}

function changeSlide(n) {
    slideIndex += n;
    showSlide(slideIndex);
}

function goToSlide(n) {
    slideIndex = n;
    showSlide(slideIndex);
}

// Auto-slide every 5 seconds
setInterval(() => {
    changeSlide(1);
}, 5000);

// Initial Display
showSlide(slideIndex);

// Footer Year Update
// Get the current year
const currentYear = new Date().getFullYear();
document.getElementById("current-year").textContent = currentYear;