document.addEventListener("DOMContentLoaded", function () {
    const menuToggle = document.querySelector(".menu-toggle");
    const navLinks = document.querySelector(".nav-links");
    const searchIcon = document.querySelector(".search-icon");
    const searchContainer = document.querySelector(".search-container");

    // Menu Toggle - Open/Close nav menu
    menuToggle.addEventListener("click", function (event) {
        event.stopPropagation(); // Prevents unwanted behavior
        navLinks.classList.toggle("active");

        // Close search if menu is opened
        searchContainer.classList.remove("active");
    });

    // Search Icon - Open/Close search input
    searchIcon.addEventListener("click", function (event) {
        event.stopPropagation(); // Prevents menu from opening
        searchContainer.classList.toggle("active");

        // Close menu if search is opened
        navLinks.classList.remove("active");
    });

    // Close both menu and search when clicking outside
    document.addEventListener("click", function (event) {
        if (!navLinks.contains(event.target) && !menuToggle.contains(event.target)) {
            navLinks.classList.remove("active");
        }

        if (!searchContainer.contains(event.target) && !searchIcon.contains(event.target)) {
            searchContainer.classList.remove("active");
        }
    });
});


// hero.js - JavaScript for Hero Section Slideshow

let currentSlide = 0;
const slides = document.querySelectorAll(".slide");
const dots = document.querySelectorAll(".dot");

function changeSlide(index) {
    slides[currentSlide].classList.remove("active");
    dots[currentSlide].classList.remove("active");
    currentSlide = index;
    slides[currentSlide].classList.add("active");
    dots[currentSlide].classList.add("active");
}

function autoSlide() {
    let nextSlide = (currentSlide + 1) % slides.length;
    changeSlide(nextSlide);
}

setInterval(autoSlide, 5000); // Change slide every 5 seconds


// Slideshow Banner
document.addEventListener("DOMContentLoaded", function () {
    const slides = document.querySelectorAll(".slide");
    const dots = document.querySelectorAll(".dot");
    let currentSlide = 0;
    let slideInterval;

    // Function to show a specific slide
    function showSlide(index) {
        // Hide all slides
        slides.forEach((slide, i) => {
            slide.classList.remove("active");
        });

        // Show the current slide
        slides[index].classList.add("active");

        // Update active dot
        dots.forEach(dot => dot.classList.remove("active"));
        dots[index].classList.add("active");

        currentSlide = index;
    }

    // Function to move to the next slide
    function nextSlide() {
        let newIndex = (currentSlide + 1) % slides.length;
        showSlide(newIndex);
    }

    // Start the slideshow
    function startSlideshow() {
        slideInterval = setInterval(nextSlide, 5000); // Change slide every 5 seconds
    }

    // Stop the slideshow
    function stopSlideshow() {
        clearInterval(slideInterval);
    }

    // Initialize the slideshow
    showSlide(currentSlide);
    startSlideshow();

    // Dot navigation
    dots.forEach((dot, index) => {
        dot.addEventListener("click", () => {
            stopSlideshow(); // Stop auto-sliding when user interacts
            showSlide(index);
            startSlideshow(); // Restart auto-sliding
        });
    });
});

// SHOP CATEGORY PRODUCT SECTION
document.addEventListener("DOMContentLoaded", function () {
    const buttons = document.querySelectorAll(".category-btn");
    const products = document.querySelectorAll(".product");

    buttons.forEach(button => {
        button.addEventListener("click", function () {
            const category = this.getAttribute("data-category");

            // Remove active class from all buttons
            buttons.forEach(btn => btn.classList.remove("active"));
            
            // Add active class to clicked button
            this.classList.add("active");

            // Show/hide products based on category
            products.forEach(product => {
                if (category === "All" || product.getAttribute("data-category") === category) {
                    product.style.display = "block";
                } else {
                    product.style.display = "none";
                }
            });
        });
    });
});


// TOGGLE OFFERS SECTION
document.addEventListener("DOMContentLoaded", function () {
    console.log("DOM fully loaded and parsed"); // Debugging line
    const buttons = document.querySelectorAll(".category-button");
    const menProducts = document.querySelector(".men-products");
    const womenProducts = document.querySelector(".women-products");

    buttons.forEach((button) => {
        button.addEventListener("click", function () {
            console.log("Button clicked:", this.getAttribute("data-category")); // Debugging line
            buttons.forEach((btn) => btn.classList.remove("active"));
            this.classList.add("active");

            const category = this.getAttribute("data-category");

            if (category === "men") {
                menProducts.style.display = "flex";
                womenProducts.style.display = "none";
            } else if (category === "women") {
                womenProducts.style.display = "flex";
                menProducts.style.display = "none";
            }
        });
    });

    // Ensure the initial category is set (e.g., Men is default)
    document.querySelector(".category-button.active").click();
});

document.addEventListener("DOMContentLoaded", function () {
    const track = document.querySelector(".testimonial-track");
    const testimonials = document.querySelectorAll(".testimonial");
    const prevBtn = document.querySelector(".prev-btn");
    const nextBtn = document.querySelector(".next-btn");
    let currentIndex = 0;
    let totalSlides = testimonials.length;

    function updateSlider() {
        let slideWidth = document.querySelector(".testimonial").offsetWidth;
        track.style.transform = `translateX(-${currentIndex * slideWidth}px)`;
    }

    function nextSlide() {
        if (currentIndex < totalSlides - 1) {
            currentIndex++;
        } else {
            currentIndex = 0; // Loop back to the first slide
        }
        updateSlider();
    }

    function prevSlide() {
        if (currentIndex > 0) {
            currentIndex--;
        } else {
            currentIndex = totalSlides - 1; // Loop to the last slide
        }
        updateSlider();
    }

    nextBtn.addEventListener("click", nextSlide);
    prevBtn.addEventListener("click", prevSlide);

    // Auto-slide every 5 seconds
    setInterval(nextSlide, 5000);

    // Update slider on window resize to keep it dynamic
    window.addEventListener("resize", updateSlider);

    // Set initial position
    updateSlider();
});
