<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Customer Reviews</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Customer Reviews</li>
                </ol>

<!-- CUSTOMER REVIEWS SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Customer Reviews</div>
                    <div class="ibox-tools">
                        <a class="ibox-collapse"><i class="fa fa-minus"></i></a>
                        <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-v"></i></a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a class="dropdown-item">View All Reviews</a>
                            <a class="dropdown-item">Manage Reviews</a>
                        </div>
                    </div>
                </div>
                <div class="ibox-body">
                    <!-- ACTION BAR -->
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3">
                        <div class="mb-2 mb-md-0">
                            <button class="btn btn-primary"><i class="fa fa-eye"></i> View All</button>
                            <button class="btn btn-success"><i class="fa fa-check"></i> Approve Review</button>
                            <button class="btn btn-danger"><i class="fa fa-trash"></i> Delete Selected</button>
                        </div>
                        <div>
                            <select class="form-control w-auto">
                                <option>Sort by Date</option>
                                <option>Sort by Rating</option>
                                <option>Sort by Customer</option>
                            </select>
                        </div>
                    </div>

                    <!-- CUSTOMER REVIEWS TABLE -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Customer</th>
                                    <th>Product</th>
                                    <th>Rating</th>
                                    <th>Review</th>
                                    <th>Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>John Doe</td>
                                    <td>Kenyan Coffee Beans</td>
                                    <td>
                                        ⭐⭐⭐⭐⭐
                                    </td>
                                    <td>"Amazing quality! Fresh and rich flavor."</td>
                                    <td>02/10/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-success" title="Approve">
                                            <i class="fa fa-check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>Jane Smith</td>
                                    <td>Handmade Wooden Bowl</td>
                                    <td>
                                        ⭐⭐⭐⭐☆
                                    </td>
                                    <td>"Beautiful craftsmanship, but slightly smaller than expected."</td>
                                    <td>02/12/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-success" title="Approve">
                                            <i class="fa fa-check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>3</td>
                                    <td>Michael Brown</td>
                                    <td>Maasai Shuka Blanket</td>
                                    <td>
                                        ⭐⭐⭐⭐⭐
                                    </td>
                                    <td>"Super warm and soft. Love the colors!"</td>
                                    <td>02/15/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-success" title="Approve">
                                            <i class="fa fa-check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>4</td>
                                    <td>Sarah Wilson</td>
                                    <td>Handcrafted Jewelry Set</td>
                                    <td>
                                        ⭐⭐⭐☆☆
                                    </td>
                                    <td>"Nice design, but took a while to arrive."</td>
                                    <td>02/18/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-success" title="Approve">
                                            <i class="fa fa-check"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- PAGINATION -->
                    <div class="mt-3 text-center">
                        <button class="btn btn-light">Previous</button>
                        <button class="btn btn-light">Next</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END CUSTOMER REVIEWS SECTION -->

<!-- RESPONSIVE STYLES -->
<style>
    @media (max-width: 768px) {
        .table-responsive {
            overflow-x: auto;
        }

        .btn {
            font-size: 12px;
            padding: 6px 10px;
        }

        .form-control {
            font-size: 14px;
        }

        .ibox-head {
            flex-wrap: wrap;
        }

        .badge {
            font-size: 12px;
            padding: 5px 8px;
        }
    }
</style>


            </div>

        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
