<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Shop Discounts</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Discounts</li>
                </ol>

<!-- MANAGE DISCOUNTS SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Manage Discounts</div>
                    <div class="ibox-tools">
                        <a class="ibox-collapse"><i class="fa fa-minus"></i></a>
                        <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-v"></i></a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a class="dropdown-item">View All Discounts</a>
                            <a class="dropdown-item">Generate New Discount Code</a>
                        </div>
                    </div>
                </div>
                <div class="ibox-body">
                    <!-- ACTION BAR -->
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div>
                            <button class="btn btn-primary" data-toggle="modal" data-target="#addDiscountModal"><i class="fa fa-plus"></i> Add Discount</button>
                        </div>
                        <div>
                            <select class="form-control w-auto">
                                <option>Sort by Discount Code</option>
                                <option>Sort by Expiry Date</option>
                                <option>Sort by Discount Amount</option>
                            </select>
                        </div>
                    </div>

                    <!-- DISCOUNT TABLE -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Discount Code</th>
                                    <th>Discount Type</th>
                                    <th>Discount Amount</th>
                                    <th>Expiry Date</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>WINTER2025</td>
                                    <td>Percentage</td>
                                    <td>15%</td>
                                    <td>01/06/2025</td>
                                    <td><span class="badge badge-success">Active</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit" data-toggle="modal" data-target="#editDiscountModal">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>SUMMER2025</td>
                                    <td>Fixed Amount</td>
                                    <td>$10</td>
                                    <td>15/07/2025</td>
                                    <td><span class="badge badge-danger">Expired</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit" data-toggle="modal" data-target="#editDiscountModal">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>3</td>
                                    <td>WELCOME10</td>
                                    <td>Percentage</td>
                                    <td>10%</td>
                                    <td>30/05/2025</td>
                                    <td><span class="badge badge-success">Active</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit" data-toggle="modal" data-target="#editDiscountModal">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- PAGINATION -->
                    <div class="mt-3 text-center">
                        <button class="btn btn-light">Previous</button>
                        <button class="btn btn-light">Next</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END MANAGE DISCOUNTS SECTION -->

<!-- MODAL FOR ADDING A NEW DISCOUNT -->
<div class="modal fade" id="addDiscountModal" tabindex="-1" role="dialog" aria-labelledby="addDiscountModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addDiscountModalLabel">Add New Discount</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <label for="discountCode">Discount Code</label>
                        <input type="text" class="form-control" id="discountCode" placeholder="Enter discount code">
                    </div>
                    <div class="form-group">
                        <label for="discountType">Discount Type</label>
                        <select class="form-control" id="discountType">
                            <option>Percentage</option>
                            <option>Fixed Amount</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="discountAmount">Discount Amount</label>
                        <input type="text" class="form-control" id="discountAmount" placeholder="Enter discount amount">
                    </div>
                    <div class="form-group">
                        <label for="expiryDate">Expiry Date</label>
                        <input type="date" class="form-control" id="expiryDate">
                    </div>
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-control" id="status">
                            <option>Active</option>
                            <option>Inactive</option>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary">Save Discount</button>
            </div>
        </div>
    </div>
</div>

<!-- MODAL FOR EDITING A DISCOUNT -->
<div class="modal fade" id="editDiscountModal" tabindex="-1" role="dialog" aria-labelledby="editDiscountModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editDiscountModalLabel">Edit Discount</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <label for="editDiscountCode">Discount Code</label>
                        <input type="text" class="form-control" id="editDiscountCode" value="WINTER2025" disabled>
                    </div>
                    <div class="form-group">
                        <label for="editDiscountType">Discount Type</label>
                        <select class="form-control" id="editDiscountType">
                            <option>Percentage</option>
                            <option>Fixed Amount</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="editDiscountAmount">Discount Amount</label>
                        <input type="text" class="form-control" id="editDiscountAmount" value="15%">
                    </div>
                    <div class="form-group">
                        <label for="editExpiryDate">Expiry Date</label>
                        <input type="date" class="form-control" id="editExpiryDate" value="2025-06-01">
                    </div>
                    <div class="form-group">
                        <label for="editStatus">Status</label>
                        <select class="form-control" id="editStatus">
                            <option>Active</option>
                            <option>Inactive</option>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </div>
</div>

<!-- RESPONSIVE STYLES -->
<style>
    @media (max-width: 768px) {
        .table-responsive {
            overflow-x: auto;
        }

        .btn {
            font-size: 12px;
            padding: 6px 10px;
        }

        .form-control {
            font-size: 14px;
        }

        .ibox-head {
            flex-wrap: wrap;
        }

        .badge {
            font-size: 12px;
            padding: 5px 8px;
        }
    }
</style>

            </div>

        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
