<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Events </h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Events</li>
                </ol>

<!-- START HIKING EVENTS MANAGEMENT SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <!-- LEFT SIDE: Calendar -->
        <div class="col-lg-8">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Hiking Events Calendar</div>
                </div>
                <div class="ibox-body">
                    <!-- Calendar -->
                    <div id="calendar"></div>
                </div>
            </div>
        </div>

        <!-- RIGHT SIDE: Event Management -->
        <div class="col-lg-4">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Upcoming Hiking Events</div>
                </div>
                <div class="ibox-body">
                    <!-- Event List -->
                    <ul class="list-group">
                        <li class="list-group-item">
                            <strong>Mountain Trek</strong><br>
                            Date: <strong>2025-04-01</strong><br>
                            Location: <strong>Switzerland</strong><br>
                        </li>
                        <li class="list-group-item">
                            <strong>Desert Safari</strong><br>
                            Date: <strong>2025-06-01</strong><br>
                            Location: <strong>Morocco</strong><br>
                        </li>
                    </ul>
                </div>
            </div>

            <!-- ADD EVENT BUTTON -->
            <button class="btn btn-primary">
                <i class="fa fa-plus"></i> Add New Event
            </button>
        </div>
    </div>
</div>

<!-- Calendar CSS and Styles -->
<style>
    #calendar {
        display: flex;
        flex-wrap: wrap;
        width: 100%;
    }
    .calendar-day {
        width: calc(100% / 7);
        height: 120px;
        border: 1px solid #ddd;
        box-sizing: border-box;
        padding: 10px;
        text-align: center;
        font-weight: bold;
    }
    .calendar-day:hover {
        background-color: #f0f0f0;
        cursor: pointer;
    }
    .calendar-header {
        display: flex;
        width: 100%;
        justify-content: space-between;
        margin-bottom: 20px;
    }
    .calendar-header button {
        background-color: #4CAF50;
        color: white;
        border: none;
        padding: 10px 15px;
        font-size: 16px;
        cursor: pointer;
    }
</style>

<!-- Calendar JavaScript -->
<script>
    // Get current date
    const currentDate = new Date();
    let currentMonth = currentDate.getMonth();
    let currentYear = currentDate.getFullYear();

    // Month names
    const months = [
        'January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December'
    ];

    // Generate calendar
    function generateCalendar() {
        const calendarElement = document.getElementById('calendar');
        calendarElement.innerHTML = '';

        // Set calendar header
        const header = document.createElement('div');
        header.classList.add('calendar-header');
        header.innerHTML = `
            <button onclick="changeMonth(-1)">&#10094;</button>
            <span>${months[currentMonth]} ${currentYear}</span>
            <button onclick="changeMonth(1)">&#10095;</button>
        `;
        calendarElement.appendChild(header);

        // Get the first day of the month and number of days in the month
        const firstDay = new Date(currentYear, currentMonth, 1).getDay();
        const daysInMonth = new Date(currentYear, currentMonth + 1, 0).getDate();

        // Create the calendar days
        for (let i = 0; i < firstDay; i++) {
            const emptyDay = document.createElement('div');
            emptyDay.classList.add('calendar-day');
            calendarElement.appendChild(emptyDay);
        }

        for (let day = 1; day <= daysInMonth; day++) {
            const dayElement = document.createElement('div');
            dayElement.classList.add('calendar-day');
            dayElement.textContent = day;
            dayElement.onclick = function() {
                alert('You clicked on ' + months[currentMonth] + ' ' + day + ', ' + currentYear);
            };
            calendarElement.appendChild(dayElement);
        }
    }

    // Change month
    function changeMonth(direction) {
        currentMonth += direction;
        if (currentMonth < 0) {
            currentMonth = 11;
            currentYear--;
        } else if (currentMonth > 11) {
            currentMonth = 0;
            currentYear++;
        }
        generateCalendar();
    }

    // Generate initial calendar
    generateCalendar();
</script>
<!-- END HIKING EVENTS MANAGEMENT SECTION -->

<!-- END HIKING EVENTS MANAGEMENT SECTION -->

            </div>

        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
