<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Roaming Ndovu | Media Management</title>
    <!-- GLOBAL MAINLY STYLES -->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES -->
    <link href="assets/css/main.min.css" rel="stylesheet" />
    <!-- CUSTOM STYLES -->
    <style>
        .media-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(150px, 1fr));
            gap: 10px;
        }

        .media-item {
            position: relative;
            overflow: hidden;
            border: 1px solid #ddd;
            border-radius: 5px;
        }

        .media-item img,
        .media-item video {
            width: 100%;
            height: auto;
            display: block;
        }

        .media-item .actions {
            position: absolute;
            bottom: 5px;
            right: 5px;
        }

        .media-item button {
            font-size: 12px;
        }
        @media screen and (max-width: 768px) {
            .media-item {
            height:24vh;
        }
        .media-controls{
            display:flex;
        }
        .media-controls button{
            margin-top:3%;
        }
         }
    </style>
</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php include 'header-sidebar.php'; ?>

        <div class="content-wrapper">
            <!-- PAGE HEADER -->
            <div class="page-heading">
                <h1 class="page-title">Media Management</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Media Management</li>
                </ol>
            </div>

            <!-- MEDIA MANAGEMENT SECTION -->
            <div class="page-content fade-in-up">
                <div class="ibox">
                    <div class="ibox-head">
                        <div class="ibox-title">Manage Media</div>
                    </div>
                    <div class="ibox-body">
                        <!-- ACTION BAR -->
                        <div class="d-flex justify-content-between align-items-center mb-3 media-controls">
                            <div>
                                <button class="btn btn-primary"><i class="fa fa-upload"></i> Upload Media</button>
                                <button class="btn btn-warning"><i class="fa fa-folder"></i> Organize</button>
                                <button class="btn btn-danger"><i class="fa fa-trash"></i> Delete Selected</button>
                            </div>
                            <div>
                                <select class="form-control">
                                    <option>Sort by Date</option>
                                    <option>Sort by Type</option>
                                    <option>Sort by Name</option>
                                </select>
                            </div>
                        </div>

                        <!-- MEDIA GRID -->
                        <div class="media-grid">
                            <!-- Sample Media Items -->
                            <div class="media-item">
                                <img src="assets/img/sample1.jpg" alt="Media Image">
                                <div class="actions">
                                    <button class="btn btn-sm btn-danger">Delete</button>
                                </div>
                            </div>
                            <div class="media-item">
                                <img src="assets/img/sample2.jpg" alt="Media Image">
                                <div class="actions">
                                    <button class="btn btn-sm btn-danger">Delete</button>
                                </div>
                            </div>
                            <div class="media-item">
                                <video controls>
                                    <source src="assets/videos/sample.mp4" type="video/mp4">
                                </video>
                                <div class="actions">
                                    <button class="btn btn-sm btn-danger">Delete</button>
                                </div>
                            </div>
                            <div class="media-item">
                                <img src="assets/img/sample3.jpg" alt="Media Image">
                                <div class="actions">
                                    <button class="btn btn-sm btn-danger">Delete</button>
                                </div>
                            </div>
                            <!-- Add more media items as needed -->
                        </div>

                        <!-- PAGINATION -->
                        <div class="mt-3 text-center">
                            <button class="btn btn-light">Previous</button>
                            <button class="btn btn-light">Next</button>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END MEDIA MANAGEMENT SECTION -->

            <footer class="page-footer">
                <div class="font-13">
                    <span id="currentYear"></span> © <b>SpaceTechDevs</b> - All rights reserved.
                </div>
                <div class="to-top"><i class="fa fa-angle-double-up"></i></div>
            </footer>
        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>

    <script>
        // Auto-update footer year
        document.getElementById("currentYear").textContent = new Date().getFullYear();
    </script>
</body>

</html>
