<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Orders</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Orders</li>
                </ol>

    <!-- CUSTOMER ORDERS SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Customer Orders</div>
                    <div class="ibox-tools">
                        <a class="ibox-collapse"><i class="fa fa-minus"></i></a>
                        <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-v"></i></a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a class="dropdown-item">View All Orders</a>
                            <a class="dropdown-item">Manage Orders</a>
                            <a class="dropdown-item">Cancel Orders</a>
                        </div>
                    </div>
                </div>
                <div class="ibox-body">
                    <!-- ACTION BAR -->
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3">
                        <div class="mb-2 mb-md-0">
                            <button class="btn btn-primary"><i class="fa fa-eye"></i> View Order</button>
                            <button class="btn btn-warning"><i class="fa fa-edit"></i> Update Order</button>
                            <button class="btn btn-danger"><i class="fa fa-trash"></i> Cancel Selected</button>
                        </div>
                        <div>
                            <select class="form-control w-auto">
                                <option>Sort by Date</option>
                                <option>Sort by Customer Name</option>
                                <option>Sort by Status</option>
                            </select>
                        </div>
                    </div>

                    <!-- ORDERS TABLE -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Order ID</th>
                                    <th>Customer Name</th>
                                    <th>Product</th>
                                    <th>Quantity</th>
                                    <th>Total Price</th>
                                    <th>Status</th>
                                    <th>Order Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>ORD-1001</td>
                                    <td>John Doe</td>
                                    <td>Kenyan Coffee Beans</td>
                                    <td>2</td>
                                    <td>$30</td>
                                    <td><span class="badge badge-success">Completed</span></td>
                                    <td>02/10/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" title="View">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Cancel">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>ORD-1002</td>
                                    <td>Jane Smith</td>
                                    <td>Handmade Wooden Bowl</td>
                                    <td>1</td>
                                    <td>$25</td>
                                    <td><span class="badge badge-warning">Pending</span></td>
                                    <td>02/11/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" title="View">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Cancel">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>3</td>
                                    <td>ORD-1003</td>
                                    <td>Michael Brown</td>
                                    <td>Maasai Shuka Blanket</td>
                                    <td>3</td>
                                    <td>$45</td>
                                    <td><span class="badge badge-danger">Cancelled</span></td>
                                    <td>02/12/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" title="View">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Cancel">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>4</td>
                                    <td>ORD-1004</td>
                                    <td>Sarah Wilson</td>
                                    <td>Handcrafted Jewelry Set</td>
                                    <td>1</td>
                                    <td>$50</td>
                                    <td><span class="badge badge-info">Processing</span></td>
                                    <td>02/13/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" title="View">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Cancel">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- PAGINATION -->
                    <div class="mt-3 text-center">
                        <button class="btn btn-light">Previous</button>
                        <button class="btn btn-light">Next</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END CUSTOMER ORDERS SECTION -->

<!-- RESPONSIVE STYLES -->
<style>
    @media (max-width: 768px) {
        .table-responsive {
            overflow-x: auto;
        }

        .btn {
            font-size: 12px;
            padding: 6px 10px;
        }

        .form-control {
            font-size: 14px;
        }

        .ibox-head {
            flex-wrap: wrap;
        }

        .badge {
            font-size: 12px;
            padding: 5px 8px;
        }
    }
</style>

            </div>

        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
