<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Hiking & Care Packages</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Packages</li>
                </ol>

<!-- START HIKING PACKAGES MANAGEMENT SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Hiking Packages Management</div>
                    <div class="ibox-tools">
                        <a class="ibox-collapse"><i class="fa fa-minus"></i></a>
                        <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-v"></i></a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a class="dropdown-item" href="add_hiking_package.php">Add New Package</a>
                            <a class="dropdown-item" href="#">Update Package</a>
                            <a class="dropdown-item" href="#">Delete Package</a>
                        </div>
                    </div>
                </div>
                <div class="ibox-body">
                    <!-- ACTION BAR -->
                    <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
                        <div class="btn-group mb-2 mb-sm-0">
                            <button class="btn btn-primary"><i class="fa fa-plus"></i> Add New Package</button>
                            <button class="btn btn-warning"><i class="fa fa-edit"></i> Update Package</button>
                            <button class="btn btn-danger"><i class="fa fa-trash"></i> Delete Selected</button>
                        </div>
                        <div class="form-group mb-2 mb-sm-0">
                            <select class="form-control">
                                <option>Sort by Name</option>
                                <option>Sort by Price</option>
                                <option>Sort by Start Date</option>
                            </select>
                        </div>
                    </div>

                    <!-- HIKING PACKAGES TABLE -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Package Name</th>
                                    <th>Description</th>
                                    <th>Price</th>
                                    <th>Location</th>
                                    <th>Duration</th>
                                    <th>Available Slots</th>
                                    <th>Start Date</th>
                                    <th>End Date</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>Mountain Trek</td>
                                    <td>5-day mountain trek in the Alps</td>
                                    <td>$500</td>
                                    <td>Switzerland</td>
                                    <td>5 days</td>
                                    <td>20</td>
                                    <td>2025-04-01</td>
                                    <td>2025-04-05</td>
                                    <td>Active</td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>Forest Expedition</td>
                                    <td>3-day expedition through the Amazon Rainforest</td>
                                    <td>$300</td>
                                    <td>Brazil</td>
                                    <td>3 days</td>
                                    <td>15</td>
                                    <td>2025-05-15</td>
                                    <td>2025-05-18</td>
                                    <td>Active</td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>3</td>
                                    <td>Desert Safari</td>
                                    <td>7-day desert safari in the Sahara</td>
                                    <td>$600</td>
                                    <td>Morocco</td>
                                    <td>7 days</td>
                                    <td>10</td>
                                    <td>2025-06-01</td>
                                    <td>2025-06-07</td>
                                    <td>Pending</td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>4</td>
                                    <td>Coastal Adventure</td>
                                    <td>4-day coastal hike in the Mediterranean</td>
                                    <td>$400</td>
                                    <td>Spain</td>
                                    <td>4 days</td>
                                    <td>25</td>
                                    <td>2025-07-01</td>
                                    <td>2025-07-04</td>
                                    <td>Active</td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- PAGINATION -->
                    <div class="mt-3 text-center">
                        <button class="btn btn-light">Previous</button>
                        <button class="btn btn-light">Next</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END HIKING PACKAGES MANAGEMENT SECTION -->

            </div>

        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
