<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Products</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Products</li>
                </ol>

                <!-- ALL PRODUCTS SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">All Products</div>
                    <div>
                        <button class="btn btn-primary"><i class="fa fa-plus"></i> Add New Post</button>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Product Image</th>
                                    <th>Product Name</th>
                                    <th>Category</th>
                                    <th>Price</th>
                                    <th>Stock</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>
                                        <img src="coffee.jpg" class="img-thumbnail product-img" onclick="expandImage(this)">
                                    </td>
                                    <td>Kenyan Coffee Beans</td>
                                    <td>Beverages</td>
                                    <td>$15.99</td>
                                    <td>120</td>
                                    <td>
                                        <button class="btn btn-sm btn-info" title="View"><i class="fa fa-eye"></i></button>
                                        <button class="btn btn-sm btn-warning" title="Edit"><i class="fa fa-edit"></i></button>
                                        <button class="btn btn-sm btn-danger" title="Delete"><i class="fa fa-trash"></i></button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>
                                        <img src="bowl.jpg" class="img-thumbnail product-img" onclick="expandImage(this)">
                                    </td>
                                    <td>Handmade Wooden Bowl</td>
                                    <td>Kitchenware</td>
                                    <td>$25.50</td>
                                    <td>50</td>
                                    <td>
                                        <button class="btn btn-sm btn-info" title="View"><i class="fa fa-eye"></i></button>
                                        <button class="btn btn-sm btn-warning" title="Edit"><i class="fa fa-edit"></i></button>
                                        <button class="btn btn-sm btn-danger" title="Delete"><i class="fa fa-trash"></i></button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div> 
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Image Modal -->
<div id="imageModal" class="modal fade" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Product Image</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" class="img-fluid">
            </div>
        </div>
    </div>
</div>

<!-- Script to Expand Image -->
<script>
    function expandImage(img) {
        document.getElementById("modalImage").src = img.src;
        var modal = new bootstrap.Modal(document.getElementById("imageModal"));
        modal.show();
    }
</script>

<!-- Styles for Responsive Design -->
<style>
    .product-img {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        cursor: pointer;
    }

    @media (max-width: 768px) {
        .table-responsive {
            overflow-x: auto;
        }

        .btn-sm {
            padding: 5px;
            font-size: 12px;
        }

        .product-img {
            width: 40px;
            height: 40px;
        }
    }
</style>

                <!-- END ALL PRODUCTS SECTION -->
            </div>

      
        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
