<?php
require_once 'backend/classes/Database.php';

try {
    $db = (new Database())->getConnection();

    // Admin details
    $email = 'admin@example.com';
    $password = 'admin123'; // Plain text password to hash
    $firstName = 'Admin';
    $lastName = 'User';

    // Hash the password
    $hashedPassword = password_hash($password, PASSWORD_BCRYPT);

    // Prepare and execute the insert statement
    $stmt = $db->prepare(
        "INSERT INTO admins (email, password, first_name, last_name, created_at) 
         VALUES (:email, :password, :first_name, :last_name, NOW())"
    );
    $stmt->execute([
        'email' => $email,
        'password' => $hashedPassword,
        'first_name' => $firstName,
        'last_name' => $lastName
    ]);

    echo "Initial admin inserted successfully with email: $email and hashed password.";
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>