<?php
require_once '../backend/classes/Database.php';

try {
    $db = (new Database())->getConnection();

    // Admin email to update
    $email = 'admin@gmail.com';
    $newPassword = 'admin@123'; // New plain text password to hash

    // Hash the new password
    $hashedPassword = password_hash($newPassword, PASSWORD_BCRYPT);

    // Update the password
    $stmt = $db->prepare(
        "UPDATE admins SET password = :password WHERE email = :email"
    );
    $stmt->execute([
        'password' => $hashedPassword,
        'email' => $email
    ]);

    echo "Admin password updated successfully for email: $email.";
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>