<?php
header('Content-Type: application/json');
require_once __DIR__ . '/../classes/Auth.php';

$method = $_SERVER['REQUEST_METHOD'];
$path = explode('/', trim($_SERVER['PATH_INFO'] ?? '', '/'));
$version = $path[0] ?? '';
$resource = $path[1] ?? '';
$id = $path[2] ?? null;

if ($version !== 'v1') {
    http_response_code(404);
    echo json_encode(['error' => 'API version not found']);
    exit;
}

// Token authentication (except for user registration and login)
$headers = getallheaders();
$token = $headers['Authorization'] ?? '';
$auth = new Auth();
$userId = ($resource === 'users' && $method === 'POST') || ($resource === 'login' && $method === 'POST') ? null : $auth->validateToken($token);

if ($userId === false && !($resource === 'users' && $method === 'POST') && !($resource === 'login' && $method === 'POST')) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Route requests
switch ($resource) {
    case 'users':
        require_once __DIR__ . '/v1/users.php';
        break;
    case 'products':
        require_once __DIR__ . '/v1/products.php';
        break;
    case 'reviews':
        require_once __DIR__ . '/v1/reviews.php';
        break;
    case 'wishlist':
        require_once __DIR__ . '/v1/wishlist.php';
        break;
    case 'cart':
        require_once __DIR__ . '/v1/cart.php';
        break;
    case 'orders':
        require_once __DIR__ . '/v1/orders.php';
        break;
    case 'logout':
        require_once __DIR__ . '/v1/logout.php';
        break;
    case 'login':
        require_once __DIR__ . '/v1/login.php';
        break;
    case 'products':
        require_once __DIR__ . '/v1/products.php';
        break;
    case 'orders':
        require_once __DIR__ . '/v1/orders.php';
        break;
    case 'sales':
        require_once __DIR__ . '/v1/sales.php';
        break;
    case 'users':
        require_once __DIR__ . '/v1/users.php';
        break;
    default:
        http_response_code(404);
        echo json_encode(['error' => 'Resource not found']);
        exit;
}
?>