<?php
require_once __DIR__ . '/../../classes/Cart.php';

$cart = new Cart();

switch ($method) {
    case 'GET':
        echo json_encode($cart->getCart($userId));
        break;

    case 'POST':
        $data = json_decode(file_get_contents('php://input'), true);
        if (!$data || !isset($data['product_id'], $data['quantity'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Product ID and quantity required']);
            exit;
        }
        $result = $cart->addToCart($userId, $data['product_id'], $data['quantity']);
        http_response_code($result['code'] ?? 201);
        echo json_encode($result);
        break;

    case 'PUT':
        if (!$id) {
            http_response_code(400);
            echo json_encode(['error' => 'Cart ID required']);
            exit;
        }
        $data = json_decode(file_get_contents('php://input'), true);
        if (!$data || !isset($data['quantity'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Quantity required']);
            exit;
        }
        $result = $cart->updateCart($id, $userId, $data['quantity']);
        http_response_code($result['code'] ?? 200);
        echo json_encode($result);
        break;

    case 'DELETE':
        if (!$id) {
            http_response_code(400);
            echo json_encode(['error' => 'Cart ID required']);
            exit;
        }
        $result = $cart->removeFromCart($id, $userId);
        http_response_code($result['code'] ?? 200);
        echo json_encode($result);
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?>