<?php
require_once __DIR__ . '/../../../backend/classes/Database.php';
require_once __DIR__ . '/../../../backend/classes/Auth.php';

header('Access-Control-Allow-Origin: *'); // Allow all origins for development (restrict in production)
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, X-Requested-With');
header('Access-Control-Max-Age: 86400');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

$response = ['success' => false];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $email = $data['email'] ?? '';
    $password = $data['password'] ?? '';

    if (!$email || !$password) {
        $response['error'] = 'Email and password are required';
        header('Content-Type: application/json');
        echo json_encode($response);
        exit();
    }

    $db = (new Database())->getConnection();
    $stmt = $db->prepare("SELECT user_id, password FROM users WHERE email = :email AND role = 'admin'");
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        $auth = new Auth();
        $token = $auth->generateToken($user['user_id']);
        $response['success'] = true;
        $response['token'] = $token;

        setcookie('token', $token, time() + 3600, '/', '', false, true);
        // $response['redirect'] = '../dashboard/admin/index.php'; // Instruct client to redirect
        // $respons['redirect'] = '../admin/index.php';
    } else {
        $response['error'] = 'Invalid credentials';
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
?>