<?php
require_once __DIR__ . '/../../classes/Order.php';
require_once __DIR__ . '/../../classes/Vendor.php';

$order = new Order();
$vendor = new Vendor();
$isAdmin = $vendor->isAdmin($userId);

switch ($method) {
    case 'GET':
        if ($id) {
            $result = $order->getOrder($id, $userId, $isAdmin);
            if ($result) {
                echo json_encode($result);
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Order not found']);
            }
        } else {
            echo json_encode($order->getOrders($userId, $isAdmin));
        }
        break;

    case 'POST':
        $data = json_decode(file_get_contents('php://input'), true);
        if (!$data || !isset($data['shipping_address'], $data['payment_method'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Shipping address and payment method required']);
            exit;
        }
        $result = $order->createOrder($userId, $data['shipping_address'], $data['payment_method']);
        http_response_code($result['code'] ?? 201);
        echo json_encode($result);
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?>