<?php
require_once __DIR__ . '/../../classes/Database.php';

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Max-Age: 86400');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

$db = (new Database())->getConnection();
$productId = $_GET['product_id'] ?? null;

if (!$productId) {
    http_response_code(400);
    echo json_encode(['error' => 'Product ID required']);
    exit;
}

try {
    $stmt = $db->prepare("SELECT image_url FROM product_images WHERE product_id = :product_id");
    $stmt->execute([':product_id' => $productId]);
    $images = $stmt->fetchAll(PDO::FETCH_ASSOC);
    error_log("Fetched images for product_id $productId: " . json_encode($images)); // Debug log
    echo json_encode($images);
} catch (PDOException $e) {
    error_log("Database error in product_images: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['error' => 'Failed to fetch images']);
}
?>