<?php
require_once __DIR__ . '/../../classes/Review.php';
require_once __DIR__ . '/../../classes/Vendor.php';

$review = new Review();
$vendor = new Vendor();
$isAdmin = $vendor->isAdmin($userId);

switch ($method) {
    case 'GET':
        if ($id) {
            $result = $review->getReviews($id); // $id is product_id
            echo json_encode($result);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Product ID required']);
        }
        break;

    case 'POST':
        $data = json_decode(file_get_contents('php://input'), true);
        if (!$data || !isset($data['product_id'], $data['rating'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Missing required fields']);
            exit;
        }
        $result = $review->createReview($data['product_id'], $userId, $data['rating'], $data['review_text'] ?? null);
        http_response_code($result['code'] ?? 201);
        echo json_encode($result);
        break;

    case 'DELETE':
        if (!$id) {
            http_response_code(400);
            echo json_encode(['error' => 'Review ID required']);
            exit;
        }
        $result = $review->deleteReview($id, $userId, $isAdmin);
        http_response_code($result['code'] ?? 200);
        echo json_encode($result);
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?>