<?php
require_once __DIR__ . '/../../../backend/classes/Database.php';
require_once __DIR__ . '/../../../backend/classes/Auth.php';

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Authorization, Content-Type');
header('Access-Control-Max-Age: 86400');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

$headers = getallheaders();
$token = $headers['Authorization'] ?? '';
$auth = new Auth();
$userId = $auth->validateToken($token);

if (!$userId) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$db = (new Database())->getConnection();
// Assuming the sales table aggregates order data or directly stores sales figures
$stmt = $db->query("SELECT SUM(total_amount) as total_sales FROM orders WHERE status = 'completed'");
$sales = $stmt->fetch(PDO::FETCH_ASSOC);

header('Content-Type: application/json');
echo json_encode(['total' => $sales['total_sales'] ?? 0.00]);
?>