<?php
require_once __DIR__ . '/../../../backend/classes/Database.php';
require_once __DIR__ . '/../../../backend/classes/Auth.php';
require_once __DIR__ . '/../../../backend/classes/User.php';

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Max-Age: 86400');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

$headers = getallheaders();
$token = $headers['Authorization'] ?? '';
$auth = new Auth();
$userId = $auth->validateToken($token);

if (!$userId || !$auth->isAdmin($userId)) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$user = new User();

switch ($_SERVER['REQUEST_METHOD']) {
    case 'GET':
        if (isset($_GET['id'])) {
            $result = $user->getUser($_GET['id']);
            if ($result) {
                echo json_encode($result);
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'User not found']);
            }
        } else {
            echo json_encode($user->getAllUsers());
        }
        break;

    case 'POST':
        $data = json_decode(file_get_contents('php://input'), true);
        if ($data && isset($data['action']) && $data['action'] === 'delete' && isset($_GET['id'])) {
            $result = $user->deleteUser($_GET['id']);
            if ($result) {
                echo json_encode(['message' => 'User deleted successfully']);
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'Delete failed']);
            }
            exit;
        }
        // Fall through to registration if not a delete action
        if (!$data || !isset($data['email'], $data['password'], $data['first_name'], $data['last_name'], $data['phone'], $data['role'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Missing required fields']);
            exit;
        }
        $token = $user->register($data['email'], $data['password'], $data['first_name'], $data['last_name'], $data['phone'], $data['role']);
        if ($token) {
            http_response_code(201);
            echo json_encode(['token' => $token]);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Registration failed']);
        }
        break;

    case 'PUT':
        $data = json_decode(file_get_contents('php://input'), true);
        if (!isset($_GET['id']) || !$data) {
            http_response_code(400);
            echo json_encode(['error' => 'User ID and data required']);
            exit;
        }
        $result = $user->updateUser($_GET['id'], $data);
        if ($result) {
            echo json_encode(['message' => 'User updated successfully']);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Update failed']);
        }
        break;

    case 'DELETE':
        if (!isset($_GET['id'])) {
            http_response_code(400);
            echo json_encode(['error' => 'User ID required']);
            exit;
        }
        $result = $user->deleteUser($_GET['id']);
        if ($result) {
            echo json_encode(['message' => 'User deleted successfully']);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Delete failed']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?>