<?php
require_once __DIR__ . '/../../../backend/classes/Database.php';
require_once __DIR__ . '/../../../backend/classes/Auth.php';
require_once __DIR__ . '/../../../backend/classes/User.php';
require_once __DIR__ . '/../../../backend/classes/Vendor.php'; // Assuming a Vendor class

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Access-Control-Max-Age: 86400');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    exit(0);
}

$headers = getallheaders();
$token = $headers['Authorization'] ?? '';
$auth = new Auth();
$userId = $auth->validateToken($token);

if (!$userId || !$auth->isAdmin($userId)) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit();
}

$vendor = new Vendor();

switch ($_SERVER['REQUEST_METHOD']) {
    case 'GET':
        if (isset($_GET['email'])) {
            $result = $vendor->getVendorByEmail($_GET['email']);
            if ($result) {
                echo json_encode($result);
            } else {
                http_response_code(404);
                echo json_encode(['error' => 'Vendor not found']);
            }
        } else {
            echo json_encode($vendor->getAllVendors());
        }
        break;

    case 'PUT':
        $data = json_decode(file_get_contents('php://input'), true);
        if (!isset($_GET['email']) || !$data) {
            http_response_code(400);
            echo json_encode(['error' => 'Vendor email and data required']);
            exit;
        }
        $result = $vendor->updateVendor($_GET['email'], $data);
        if ($result) {
            echo json_encode(['message' => 'Vendor updated successfully']);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Update failed']);
        }
        break;

    case 'DELETE':
        if (!isset($_GET['email'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Vendor email required']);
            exit;
        }
        $result = $vendor->deleteVendor($_GET['email']);
        if ($result) {
            echo json_encode(['message' => 'Vendor deleted successfully']);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Delete failed']);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?>