<?php
require_once __DIR__ . '/../../classes/Wishlist.php';

$wishlist = new Wishlist();

switch ($method) {
    case 'GET':
        echo json_encode($wishlist->getWishlist($userId));
        break;

    case 'POST':
        $data = json_decode(file_get_contents('php://input'), true);
        if (!$data || !isset($data['product_id'])) {
            http_response_code(400);
            echo json_encode(['error' => 'Product ID required']);
            exit;
        }
        $result = $wishlist->addToWishlist($userId, $data['product_id']);
        http_response_code($result['code'] ?? 201);
        echo json_encode($result);
        break;

    case 'DELETE':
        if (!$id) {
            http_response_code(400);
            echo json_encode(['error' => 'Wishlist ID required']);
            exit;
        }
        $result = $wishlist->removeFromWishlist($userId, $id);
        http_response_code($result['code'] ?? 200);
        echo json_encode($result);
        break;

    default:
        http_response_code(405);
        echo json_encode(['error' => 'Method not allowed']);
        break;
}
?>