<?php
// /backend/classes/Auth.php
require_once __DIR__ . '/Database.php';

class Auth {
    private $db;

    public function __construct() {
        $this->db = (new Database())->getConnection();
    }

    public function generateToken($userId) {
        $token = bin2hex(random_bytes(32)); // 64-character random string
        $expiresAt = date('Y-m-d H:i:s', strtotime('+1 hour')); // 1-hour expiration

        $stmt = $this->db->prepare(
            "INSERT INTO tokens (user_id, token, expires_at) VALUES (:user_id, :token, :expires_at)"
        );
        $stmt->execute([
            'user_id' => $userId,
            'token' => $token,
            'expires_at' => $expiresAt
        ]);

        return $token;
    }

    public function validateToken($token) {
        error_log("Validating token: $token");
        $stmt = $this->db->prepare(
            "SELECT user_id FROM tokens WHERE token = :token AND expires_at > NOW()"
        );
        $stmt->execute(['token' => $token]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
        if ($result) {
            error_log("Token validated, user_id: " . $result['user_id']);
            return $result['user_id'];
        } else {
            error_log("Token validation failed for token: $token");
            return false;
        }
    }

    public function isAuthenticated() {
        // Debug: Log all cookies
        error_log('Auth.php: All cookies: ' . print_r($_COOKIE, true));

        $token = $_COOKIE['token'] ?? '';
        if (!$token) {
            error_log("isAuthenticated: No token found in cookie");
            return false;
        }

        $userId = $this->validateToken($token);
        if ($userId === false) {
            error_log("isAuthenticated: Token validation failed");
            return false;
        }

        return $userId;
    }

    public function getUserData($userId) {
        $stmt = $this->db->prepare(
            "SELECT user_id, email, role FROM users WHERE user_id = :user_id"
        );
        $stmt->execute(['user_id' => $userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);

        if ($user) {
            error_log("getUserData: User data fetched for user_id: $userId");
            return $user;
        } else {
            error_log("getUserData: No user found for user_id: $userId");
            return false;
        }
    }

    public function isAdmin($userId) {
        $stmt = $this->db->prepare("SELECT role FROM users WHERE user_id = :user_id");
        $stmt->execute([':user_id' => $userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        return $user && $user['role'] === 'admin';
    }

    public function isVendor($userId) {
        $stmt = $this->db->prepare("SELECT role FROM users WHERE user_id = :user_id");
        $stmt->execute([':user_id' => $userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        return $user && $user['role'] === 'vendor';
    }

    public function revokeToken($token) {
        $stmt = $this->db->prepare("DELETE FROM tokens WHERE token = :token");
        $stmt->execute(['token' => $token]);
    }
}
?>