<?php
require_once __DIR__ . '/Database.php';

class Cart {
    private $db;

    public function __construct() {
        $this->db = (new Database())->getConnection();
    }

    public function getCart($userId) {
        $stmt = $this->db->prepare(
            "SELECT c.*, p.name, p.price, p.primary_image 
             FROM cart c 
             JOIN products p ON c.product_id = p.product_id 
             WHERE c.user_id = :user_id AND p.is_active = 1"
        );
        $stmt->execute(['user_id' => $userId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function addToCart($userId, $productId, $quantity) {
        $stmt = $this->db->prepare(
            "INSERT INTO cart (user_id, product_id, quantity) 
             VALUES (:user_id, :product_id, :quantity) 
             ON DUPLICATE KEY UPDATE quantity = quantity + :quantity"
        );
        $result = $stmt->execute([
            'user_id' => $userId,
            'product_id' => $productId,
            'quantity' => $quantity
        ]);
        return $result ? ['message' => 'Added to cart'] : ['error' => 'Failed to add', 'code' => 500];
    }

    public function updateCart($cartId, $userId, $quantity) {
        $stmt = $this->db->prepare(
            "UPDATE cart SET quantity = :quantity WHERE cart_id = :cart_id AND user_id = :user_id"
        );
        $result = $stmt->execute([
            'cart_id' => $cartId,
            'user_id' => $userId,
            'quantity' => $quantity
        ]);
        return $result ? ['message' => 'Cart updated'] : ['error' => 'Failed to update', 'code' => 500];
    }

    public function removeFromCart($cartId, $userId) {
        $stmt = $this->db->prepare(
            "DELETE FROM cart WHERE cart_id = :cart_id AND user_id = :user_id"
        );
        $result = $stmt->execute(['cart_id' => $cartId, 'user_id' => $userId]);
        return $result ? ['message' => 'Removed from cart'] : ['error' => 'Failed to remove', 'code' => 500];
    }
}
?>