<?php
require_once __DIR__ . '/Database.php';
require_once __DIR__ . '/Auth.php';

class Vendor {
    private $db;

    public function __construct() {
        $this->db = (new Database())->getConnection();
    }

    public function getVendorByEmail($email) {
        $stmt = $this->db->prepare("SELECT vendor_id, email, vendor_name, phone, created_at, approved, bio, created_by FROM vendors WHERE email = :email");
        $stmt->execute([':email' => $email]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getAllVendors() {
        $stmt = $this->db->query("SELECT vendor_id, email, vendor_name, phone, created_at, approved, bio, created_by FROM vendors");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function updateVendor($email, $data) {
        $fields = [];
        $params = [':email' => $email];
        if (isset($data['vendor_name'])) $fields[] = "vendor_name = :vendor_name"; $params[':vendor_name'] = $data['vendor_name'];
        if (isset($data['phone'])) $fields[] = "phone = :phone"; $params[':phone'] = $data['phone'];
        if (isset($data['bio'])) $fields[] = "bio = :bio"; $params[':bio'] = $data['bio'];
        if (isset($data['approved'])) $fields[] = "approved = :approved"; $params[':approved'] = $data['approved'];

        if (empty($fields)) return false;

        $stmt = $this->db->prepare("UPDATE vendors SET " . implode(', ', $fields) . " WHERE email = :email");
        return $stmt->execute($params);
    }

    public function deleteVendor($email) {
        $stmt = $this->db->prepare("DELETE FROM vendors WHERE email = :email");
        return $stmt->execute([':email' => $email]);
    }
    public function isVendor($userId) {
        if (!$userId) return false;
        $stmt = $this->db->prepare("SELECT role FROM users WHERE user_id = :user_id");
        $stmt->execute([':user_id' => $userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        error_log("Vendor check for user_id $userId, role: " . ($user['role'] ?? 'null'));
        return $user && $user['role'] === 'vendor';
    }

    public function isAdmin($userId) {
        if (!$userId) return false;
        $stmt = $this->db->prepare("SELECT role FROM users WHERE user_id = :user_id");
        $stmt->execute([':user_id' => $userId]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        error_log("Admin check for user_id $userId, role: " . ($user['role'] ?? 'null'));
        return $user && $user['role'] === 'admin';
    }

    // Placeholder method
    public function getVendor($vendorId) {
        $stmt = $this->db->prepare("SELECT * FROM vendors WHERE vendor_id = :vendor_id AND is_active = 1");
        $stmt->execute([':vendor_id' => $vendorId]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }   
}
?>