<?php
require_once __DIR__ . '/Database.php';

class Wishlist {
    private $db;

    public function __construct() {
        $this->db = (new Database())->getConnection();
    }

    public function getWishlist($userId) {
        $stmt = $this->db->prepare(
            "SELECT w.*, p.name, p.price, p.primary_image 
             FROM wishlist w 
             JOIN products p ON w.product_id = p.product_id 
             WHERE w.user_id = :user_id AND p.is_active = 1"
        );
        $stmt->execute(['user_id' => $userId]);
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function addToWishlist($userId, $productId) {
        $stmt = $this->db->prepare(
            "INSERT IGNORE INTO wishlist (user_id, product_id) VALUES (:user_id, :product_id)"
        );
        $result = $stmt->execute(['user_id' => $userId, 'product_id' => $productId]);
        return $result ? ['message' => 'Added to wishlist'] : ['error' => 'Failed to add', 'code' => 500];
    }

    public function removeFromWishlist($userId, $wishlistId) {
        $stmt = $this->db->prepare(
            "DELETE FROM wishlist WHERE wishlist_id = :wishlist_id AND user_id = :user_id"
        );
        $result = $stmt->execute(['wishlist_id' => $wishlistId, 'user_id' => $userId]);
        return $result ? ['message' => 'Removed from wishlist'] : ['error' => 'Failed to remove', 'code' => 500];
    }
}
?>