<?php
// require_once './backend/config/database.php';

function isLoggedIn() {
    // Debug: Log all cookies
    error_log('authHelper.php: All cookies: ' . print_r($_COOKIE, true));

    // Check if cookies exist
    if (!isset($_COOKIE['auth_token'])) {
        error_log('authHelper.php: auth_token cookie not set');
        return false;
    }
    if (!isset($_COOKIE['user_id'])) {
        error_log('authHelper.php: user_id cookie not set');
        return false;
    }

    $token = $_COOKIE['auth_token'];
    $user_id = $_COOKIE['user_id'];

    // Debug: Log cookie values
    error_log("authHelper.php: auth_token: $token, user_id: $user_id");

    // Validate the token against the database
    $dbConfig = new DatabaseConfig();
    $conn = $dbConfig->getConnection();

    $stmt = $conn->prepare("SELECT * FROM tokens WHERE user_id = ? AND token = ? AND expires_at > NOW()");
    $stmt->execute([$user_id, $token]);
    $tokenRecord = $stmt->fetch(PDO::FETCH_ASSOC);

    // Debug: Log token validation result
    if ($tokenRecord === false) {
        error_log("authHelper.php: Token validation failed for user_id: $user_id");
    } else {
        error_log("authHelper.php: Token validated successfully for user_id: $user_id");
    }

    return $tokenRecord !== false;
}
?>