<?php
// Start output buffering to prevent headers from being sent prematurely
ob_start();

require_once __DIR__ . '/../../backend/classes/Database.php';
require_once __DIR__ . '/../../backend/classes/Auth.php';

header('Access-Control-Allow-Origin: *'); // Allow all origins for development (restrict in production)
header('Access-Control-Allow-Methods: POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, X-Requested-With');
header('Access-Control-Max-Age: 86400');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    ob_end_flush();
    exit(0);
}

$response = ['success' => false];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $email = $data['email'] ?? '';
    $password = $data['password'] ?? '';

    if (!$email || !$password) {
        $response['error'] = 'Email and password are required';
        header('Content-Type: application/json');
        echo json_encode($response);
        ob_end_flush();
        exit();
    }

    $db = (new Database())->getConnection();
    $stmt = $db->prepare("SELECT user_id, password FROM users WHERE email = :email AND role = 'user'");
    $stmt->execute(['email' => $email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($password, $user['password'])) {
        $auth = new Auth();
        $token = $auth->generateToken($user['user_id']);
        $response['success'] = true;
        $response['token'] = $token;

        // Set cookie with SameSite attribute
        $cookieOptions = [
            'expires' => time() + 3600,
            'path' => '/',
            'domain' => '', // Leave empty for current domain
            'secure' => false, // Set to true if using HTTPS
            'httponly' => true,
            'samesite' => 'Lax'
        ];
        $cookieSet = setcookie('token', $token, $cookieOptions);

        // Debug: Log whether the cookie was set
        if ($cookieSet) {
            error_log("login.php: Successfully set token cookie: $token");
        } else {
            error_log("login.php: Failed to set token cookie");
        }

        $response['redirect'] = '../../Shop/index.php';
    } else {
        $response['error'] = 'Invalid credentials';
    }

    header('Content-Type: application/json');
    echo json_encode($response);
    ob_end_flush();
    exit();
}

http_response_code(405);
echo json_encode(['error' => 'Method not allowed']);
ob_end_flush();
?>