<?php
header('Content-Type: application/json');
require_once "../config/database.php";

$db = new DatabaseConfig();
$conn = $db->getConnection();

$searchQuery = isset($_GET['q']) ? trim($_GET['q']) : '';
$searchResults = [];

if ($searchQuery) {
    try {
        $searchTerm = "%" . $searchQuery . "%";
        $stmt = $conn->prepare("
            SELECT p.product_id, p.name, p.primary_image 
            FROM products p 
            LEFT JOIN categories c ON p.category_id = c.category_id 
            WHERE p.is_active = 1 
            AND (p.name LIKE :search 
                 OR p.description LIKE :search 
                 OR p.tags LIKE :search 
                 OR c.name LIKE :search)
            LIMIT 5
        ");
        $stmt->bindValue(':search', $searchTerm, PDO::PARAM_STR);
        $stmt->execute();
        $searchResults = $stmt->fetchAll(PDO::FETCH_ASSOC);
    } catch (PDOException $e) {
        error_log("Search suggestions failed: " . $e->getMessage());
    }
}

echo json_encode($searchResults);
exit;