<?php
// Ensure no whitespace before the opening tag
header('Content-Type: application/json');
session_start();

// Suppress warnings and notices (for production)
error_reporting(E_ALL & ~E_WARNING & ~E_NOTICE);
ini_set('display_errors', 0);

// Include database connection
require_once "../config/database.php";

// Check if user is authenticated
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Please log in to update your profile.']);
    exit;
}

$userId = $_SESSION['user_id'];
$db = new DatabaseConfig();
$conn = $db->getConnection();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $firstName = trim($_POST['first_name'] ?? '');
    $lastName = trim($_POST['last_name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');

    // Basic validation
    if (empty($firstName) || empty($lastName) || empty($email)) {
        echo json_encode(['success' => false, 'message' => 'First name, last name, and email are required.']);
        exit;
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        echo json_encode(['success' => false, 'message' => 'Invalid email format.']);
        exit;
    }

    try {
        // Check if the email is already in use by another user
        $stmt = $conn->prepare("SELECT user_id FROM users WHERE email = :email AND user_id != :user_id");
        $stmt->execute(['email' => $email, 'user_id' => $userId]);
        if ($stmt->fetch()) {
            echo json_encode(['success' => false, 'message' => 'This email is already in use by another account.']);
            exit;
        }

        // Update user details
        $stmt = $conn->prepare("
            UPDATE users 
            SET first_name = :first_name, last_name = :last_name, email = :email, phone = :phone, updated_at = NOW()
            WHERE user_id = :user_id
        ");
        $stmt->execute([
            'first_name' => $firstName,
            'last_name' => $lastName,
            'email' => $email,
            'phone' => $phone,
            'user_id' => $userId
        ]);

        echo json_encode(['success' => true, 'message' => 'Profile updated successfully!']);
    } catch (PDOException $e) {
        error_log("Failed to update profile: " . $e->getMessage());
        echo json_encode(['success' => false, 'message' => 'An error occurred while updating your profile. Please try again.']);
    }
} else {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
}

exit;