<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
    <link rel="icon" href="../Media/logo.png" type="image/x-icon">

</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Coupons</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Coupons</li>
                </ol>

<!-- MANAGE COUPON CODES SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Manage Coupon Codes</div>
                    <div class="ibox-tools">
                        <a class="ibox-collapse"><i class="fa fa-minus"></i></a>
                        <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-v"></i></a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a class="dropdown-item">View All Coupon Codes</a>
                            <a class="dropdown-item">Generate New Coupon Code</a>
                        </div>
                    </div>
                </div>
                <div class="ibox-body">
                    <!-- ACTION BAR -->
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div>
                            <button class="btn btn-primary" data-toggle="modal" data-target="#addCouponModal"><i class="fa fa-plus"></i> Add Coupon</button>
                        </div>
                        <div>
                            <select class="form-control w-auto">
                                <option>Sort by Code</option>
                                <option>Sort by Expiry Date</option>
                                <option>Sort by Discount Type</option>
                            </select>
                        </div>
                    </div>

                    <!-- COUPON CODE TABLE -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Coupon Code</th>
                                    <th>Associated Discount</th>
                                    <th>Discount Type</th>
                                    <th>Expiry Date</th>
                                    <th>Usage Limit</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>SPRINGSALE25</td>
                                    <td>WINTER2025</td>
                                    <td>Percentage</td>
                                    <td>01/06/2025</td>
                                    <td>100 uses</td>
                                    <td><span class="badge badge-success">Active</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit" data-toggle="modal" data-target="#editCouponModal">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>SUMMERDEAL10</td>
                                    <td>WELCOME10</td>
                                    <td>Fixed Amount</td>
                                    <td>15/07/2025</td>
                                    <td>50 uses</td>
                                    <td><span class="badge badge-danger">Expired</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit" data-toggle="modal" data-target="#editCouponModal">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>3</td>
                                    <td>NEWYEAR30</td>
                                    <td>WINTER2025</td>
                                    <td>Percentage</td>
                                    <td>31/12/2025</td>
                                    <td>200 uses</td>
                                    <td><span class="badge badge-success">Active</span></td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit" data-toggle="modal" data-target="#editCouponModal">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- PAGINATION -->
                    <div class="mt-3 text-center">
                        <button class="btn btn-light">Previous</button>
                        <button class="btn btn-light">Next</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END MANAGE COUPON CODES SECTION -->

<!-- MODAL FOR ADDING A NEW COUPON CODE -->
<div class="modal fade" id="addCouponModal" tabindex="-1" role="dialog" aria-labelledby="addCouponModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addCouponModalLabel">Add New Coupon Code</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <label for="couponCode">Coupon Code</label>
                        <input type="text" class="form-control" id="couponCode" placeholder="Enter coupon code">
                    </div>
                    <div class="form-group">
                        <label for="associatedDiscount">Associated Discount</label>
                        <select class="form-control" id="associatedDiscount">
                            <option>WINTER2025</option>
                            <option>SUMMERDEAL10</option>
                            <option>NEWYEAR30</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="discountType">Discount Type</label>
                        <select class="form-control" id="discountType">
                            <option>Percentage</option>
                            <option>Fixed Amount</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="expiryDate">Expiry Date</label>
                        <input type="date" class="form-control" id="expiryDate">
                    </div>
                    <div class="form-group">
                        <label for="usageLimit">Usage Limit</label>
                        <input type="number" class="form-control" id="usageLimit" placeholder="Enter usage limit">
                    </div>
                    <div class="form-group">
                        <label for="status">Status</label>
                        <select class="form-control" id="status">
                            <option>Active</option>
                            <option>Inactive</option>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary">Save Coupon Code</button>
            </div>
        </div>
    </div>
</div>

<!-- MODAL FOR EDITING A COUPON CODE -->
<div class="modal fade" id="editCouponModal" tabindex="-1" role="dialog" aria-labelledby="editCouponModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="editCouponModalLabel">Edit Coupon Code</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form>
                    <div class="form-group">
                        <label for="editCouponCode">Coupon Code</label>
                        <input type="text" class="form-control" id="editCouponCode" value="SPRINGSALE25" disabled>
                    </div>
                    <div class="form-group">
                        <label for="editAssociatedDiscount">Associated Discount</label>
                        <select class="form-control" id="editAssociatedDiscount">
                            <option>WINTER2025</option>
                            <option>SUMMERDEAL10</option>
                            <option>NEWYEAR30</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="editDiscountType">Discount Type</label>
                        <select class="form-control" id="editDiscountType">
                            <option>Percentage</option>
                            <option>Fixed Amount</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="editExpiryDate">Expiry Date</label>
                        <input type="date" class="form-control" id="editExpiryDate" value="2025-06-01">
                    </div>
                    <div class="form-group">
                        <label for="editUsageLimit">Usage Limit</label>
                        <input type="number" class="form-control" id="editUsageLimit" value="100">
                    </div>
                    <div class="form-group">
                        <label for="editStatus">Status</label>
                        <select class="form-control" id="editStatus">
                            <option>Active</option>
                            <option>Inactive</option>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary">Save Changes</button>
            </div>
        </div>
    </div>
</div>

<!-- RESPONSIVE STYLES -->
<style>
    @media (max-width: 768px) {
        .table-responsive {
            overflow-x: auto;
        }

        .btn {
            font-size: 12px;
            padding: 6px 10px;
        }

        .form-control {
            font-size: 14px;
        }

        .ibox-head {
            flex-wrap: wrap;
        }

        .badge {
            font-size: 12px;
            padding: 5px 8px;
        }
    }
</style>

            </div>

        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
