<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
    <link rel="icon" href="../Media/logo.png" type="image/x-icon">

</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Customers</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Customers</li>
                </ol>

 <!-- PREVIOUS CUSTOMERS WITH ORDERS SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Previous Customers & Orders</div>
                    <div class="ibox-tools">
                        <a class="ibox-collapse"><i class="fa fa-minus"></i></a>
                        <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-v"></i></a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a class="dropdown-item">View Customer Details</a>
                            <a class="dropdown-item">Manage Orders</a>
                            <a class="dropdown-item">Contact Customer</a>
                        </div>
                    </div>
                </div>
                <div class="ibox-body">
                    <!-- ACTION BAR -->
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3">
                        <div class="mb-2 mb-md-0">
                            <button class="btn btn-primary"><i class="fa fa-eye"></i> View Customer</button>
                            <button class="btn btn-success"><i class="fa fa-phone"></i> Contact Customer</button>
                            <button class="btn btn-warning"><i class="fa fa-history"></i> Order History</button>
                        </div>
                        <div>
                            <select class="form-control w-auto">
                                <option>Sort by Name</option>
                                <option>Sort by Total Orders</option>
                                <option>Sort by Last Order Date</option>
                            </select>
                        </div>
                    </div>

                    <!-- CUSTOMERS TABLE -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Customer ID</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Phone</th>
                                    <th>Total Orders</th>
                                    <th>Last Order</th>
                                    <th>Total Spent</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>CUST-001</td>
                                    <td>John Doe</td>
                                    <td>johndoe@email.com</td>
                                    <td>+254 712 345678</td>
                                    <td>5</td>
                                    <td>02/10/2025</td>
                                    <td>$150</td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" title="View">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success" title="Contact">
                                            <i class="fa fa-phone"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Order History">
                                            <i class="fa fa-history"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>CUST-002</td>
                                    <td>Jane Smith</td>
                                    <td>janesmith@email.com</td>
                                    <td>+254 723 456789</td>
                                    <td>3</td>
                                    <td>02/11/2025</td>
                                    <td>$90</td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" title="View">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success" title="Contact">
                                            <i class="fa fa-phone"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Order History">
                                            <i class="fa fa-history"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>3</td>
                                    <td>CUST-003</td>
                                    <td>Michael Brown</td>
                                    <td>michaelbrown@email.com</td>
                                    <td>+254 734 567890</td>
                                    <td>7</td>
                                    <td>02/12/2025</td>
                                    <td>$200</td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" title="View">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success" title="Contact">
                                            <i class="fa fa-phone"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Order History">
                                            <i class="fa fa-history"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>4</td>
                                    <td>CUST-004</td>
                                    <td>Sarah Wilson</td>
                                    <td>sarahwilson@email.com</td>
                                    <td>+254 745 678901</td>
                                    <td>4</td>
                                    <td>02/13/2025</td>
                                    <td>$120</td>
                                    <td>
                                        <button class="btn btn-sm btn-primary" title="View">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-success" title="Contact">
                                            <i class="fa fa-phone"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Order History">
                                            <i class="fa fa-history"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- PAGINATION -->
                    <div class="mt-3 text-center">
                        <button class="btn btn-light">Previous</button>
                        <button class="btn btn-light">Next</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END PREVIOUS CUSTOMERS SECTION -->

<!-- RESPONSIVE STYLES -->
<style>
    @media (max-width: 768px) {
        .table-responsive {
            overflow-x: auto;
        }

        .btn {
            font-size: 12px;
            padding: 6px 10px;
        }

        .form-control {
            font-size: 14px;
        }

        .ibox-head {
            flex-wrap: wrap;
        }

        .badge {
            font-size: 12px;
            padding: 5px 8px;
        }
    }
</style>

            </div>

        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
