<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- PLUGINS STYLES-->
    <link href="./assets/vendors/fullcalendar/dist/fullcalendar.min.css" rel="stylesheet" />
    <link href="./assets/vendors/fullcalendar/dist/fullcalendar.print.min.css" rel="stylesheet" media="print" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
    <!-- PAGE LEVEL STYLES-->
    <link rel="icon" href="../Media/logo.png" type="image/x-icon">

</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
        include 'header-sidebar.php';
        ?>
        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Calendar</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Calendar</li>
                </ol>
            </div>
            <div class="page-content fade-in-up">
                <div class="row">
                    <div class="col-md-3">
                        <div id="external-events">
                            <h5 class="m-b-10">Draggable Events</h5>
                            <div class="ex-event bg-green" data-class="bg-green">My Event 1</div>
                            <div class="ex-event bg-blue" data-class="bg-blue">My Event 2</div>
                            <div class="ex-event bg-orange" data-class="bg-orange">My Event 3</div>
                            <div class="ex-event bg-red" data-class="bg-red">My Event 4</div>
                            <div class="ex-event bg-silver" data-class="bg-silver">My Event 5</div>
                            <p class="m-l-10 m-t-20">
                                <label>
                                    <input class="m-r-5" id="drop-remove" type="checkbox">remove after drop</label>
                            </p>
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="ibox">
                            <div class="ibox-body">
                                <div id="calendar"></div>
                                <!-- New Event Dialog-->
                                <div class="modal fade" id="new-event-modal" tabindex="-1" role="dialog">
                                    <div class="modal-dialog" role="document">
                                        <form class="modal-content form-horizontal" action="javascript:;">
                                            <div class="modal-header bg-silver-100">
                                                <h4 class="modal-title">New Event</h4>
                                                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="form-group row">
                                                    <label class="col-sm-2 col-form-label">Title:</label>
                                                    <div class="col-sm-10">
                                                        <input class="form-control" id="new-event-title" type="text">
                                                    </div>
                                                </div>
                                                <div class="form-group row" id="date_1">
                                                    <label class="col-sm-2 col-form-label">Start:</label>
                                                    <div class="col-sm-10">
                                                        <div class="input-group datepicker date">
                                                            <span class="input-group-addon bg-white"><i class="fa fa-calendar"></i></span>
                                                            <input class="form-control" id="new-event-start" type="text" value="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-sm-2 col-form-label">End:</label>
                                                    <div class="col-sm-10">
                                                        <div class="input-group datepicker date">
                                                            <span class="input-group-addon bg-white"><i class="fa fa-calendar"></i></span>
                                                            <input class="form-control" id="new-event-end" type="text">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-sm-2 col-form-label">Color:</label>
                                                    <div class="col-sm-10">
                                                        <select class="form-control" id="new-event-color">
                                                            <option value="bg-blue">Blue</option>
                                                            <option value="bg-red">Red</option>
                                                            <option value="bg-green">Green</option>
                                                            <option value="bg-orange">Orange</option>
                                                            <option value="bg-silver">Silver</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <div class="col-sm-10 ml-sm-auto">
                                                        <label class="ui-checkbox ui-checkbox-info">
                                                            <input id="new-event-allDay" type="checkbox">
                                                            <span class="input-span"></span>All Day</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button class="btn btn-default" type="button" data-dismiss="modal">Close</button>
                                                <button class="btn btn-info" id="addEventButton" type="submit">Add event</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <!-- End New Event Dialog-->
                                <!-- Event Detail Dialog-->
                                <div class="modal fade" id="event-modal" tabindex="-1" role="dialog">
                                    <div class="modal-dialog" role="document">
                                        <form class="modal-content form-horizontal" action="javascript:;">
                                            <div class="modal-header bg-silver-100">
                                                <h4 class="modal-title">Edit Event</h4>
                                                <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                                                    <span aria-hidden="true">×</span>
                                                </button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="form-group row">
                                                    <label class="col-sm-2 col-form-label">Title:</label>
                                                    <div class="col-sm-10">
                                                        <input class="form-control" id="event-title" type="text">
                                                    </div>
                                                </div>
                                                <div class="form-group row" id="date_1">
                                                    <label class="col-sm-2 col-form-label">Start:</label>
                                                    <div class="col-sm-10">
                                                        <div class="input-group datepicker date">
                                                            <span class="input-group-addon bg-white"><i class="fa fa-calendar"></i></span>
                                                            <input class="form-control" id="event-start" type="text" value="">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-sm-2 col-form-label">End:</label>
                                                    <div class="col-sm-10">
                                                        <div class="input-group datepicker date">
                                                            <span class="input-group-addon bg-white"><i class="fa fa-calendar"></i></span>
                                                            <input class="form-control" id="event-end" type="text">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label class="col-sm-2 col-form-label">Color:</label>
                                                    <div class="col-sm-10">
                                                        <select class="form-control" id="event-color">
                                                            <option value="bg-blue">Blue</option>
                                                            <option value="bg-red">Red</option>
                                                            <option value="bg-green">Green</option>
                                                            <option value="bg-orange">Orange</option>
                                                            <option value="bg-silver">Silver</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <div class="col-sm-10 ml-sm-auto">
                                                        <label class="ui-checkbox ui-checkbox-info">
                                                            <input id="event-allDay" type="checkbox">
                                                            <span class="input-span"></span>All Day</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button class="btn btn-info" id="editEventButton" type="submit">Save</button>
                                                <button class="btn btn-danger" id="deleteEventButton" type="button" data-dismiss="modal">Delete</button>
                                                <button class="btn btn-default" type="button" data-dismiss="modal">Close</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                                <!-- End Event Detail Dialog-->
                            </div>
                        </div>
                    </div>
                </div>
                
            <!-- END PAGE CONTENT-->
            <footer class="page-footer">
            <div class="font-13">
           <span id="currentYear"></span> © <b>SpaceTechDevs</b> - All rights reserved.
            </div>
                <div class="to-top"><i class="fa fa-angle-double-up"></i></div>
            </footer>

            <script>
         document.getElementById("currentYear").textContent = new Date().getFullYear();
        </script>
        </div>
    </div>
    <!-- BEGIN THEME CONFIG PANEL-->
    <div class="theme-config">
        <div class="theme-config-toggle"><i class="fa fa-cog theme-config-show"></i><i class="ti-close theme-config-close"></i></div>
        <div class="theme-config-box">
            <div class="text-center font-18 m-b-20">SETTINGS</div>
            <div class="font-strong">LAYOUT OPTIONS</div>
            <div class="check-list m-b-20 m-t-10">
                <label class="ui-checkbox ui-checkbox-gray">
                    <input id="_fixedNavbar" type="checkbox" checked>
                    <span class="input-span"></span>Fixed navbar</label>
                <label class="ui-checkbox ui-checkbox-gray">
                    <input id="_fixedlayout" type="checkbox">
                    <span class="input-span"></span>Fixed layout</label>
                <label class="ui-checkbox ui-checkbox-gray">
                    <input class="js-sidebar-toggler" type="checkbox">
                    <span class="input-span"></span>Collapse sidebar</label>
            </div>
            <div class="font-strong">LAYOUT STYLE</div>
            <div class="m-t-10">
                <label class="ui-radio ui-radio-gray m-r-10">
                    <input type="radio" name="layout-style" value="" checked="">
                    <span class="input-span"></span>Fluid</label>
                <label class="ui-radio ui-radio-gray">
                    <input type="radio" name="layout-style" value="1">
                    <span class="input-span"></span>Boxed</label>
            </div>
            <div class="m-t-10 m-b-10 font-strong">THEME COLORS</div>
            <div class="d-flex m-b-20">
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Default">
                    <label>
                        <input type="radio" name="setting-theme" value="default" checked="">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-white"></div>
                        <div class="color-small bg-ebony"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Blue">
                    <label>
                        <input type="radio" name="setting-theme" value="blue">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-blue"></div>
                        <div class="color-small bg-ebony"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Green">
                    <label>
                        <input type="radio" name="setting-theme" value="green">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-green"></div>
                        <div class="color-small bg-ebony"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Purple">
                    <label>
                        <input type="radio" name="setting-theme" value="purple">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-purple"></div>
                        <div class="color-small bg-ebony"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Orange">
                    <label>
                        <input type="radio" name="setting-theme" value="orange">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-orange"></div>
                        <div class="color-small bg-ebony"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Pink">
                    <label>
                        <input type="radio" name="setting-theme" value="pink">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-pink"></div>
                        <div class="color-small bg-ebony"></div>
                    </label>
                </div>
            </div>
            <div class="d-flex">
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="White">
                    <label>
                        <input type="radio" name="setting-theme" value="white">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color"></div>
                        <div class="color-small bg-silver-100"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Blue light">
                    <label>
                        <input type="radio" name="setting-theme" value="blue-light">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-blue"></div>
                        <div class="color-small bg-silver-100"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Green light">
                    <label>
                        <input type="radio" name="setting-theme" value="green-light">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-green"></div>
                        <div class="color-small bg-silver-100"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Purple light">
                    <label>
                        <input type="radio" name="setting-theme" value="purple-light">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-purple"></div>
                        <div class="color-small bg-silver-100"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Orange light">
                    <label>
                        <input type="radio" name="setting-theme" value="orange-light">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-orange"></div>
                        <div class="color-small bg-silver-100"></div>
                    </label>
                </div>
                <div class="color-skin-box" data-toggle="tooltip" data-original-title="Pink light">
                    <label>
                        <input type="radio" name="setting-theme" value="pink-light">
                        <span class="color-check-icon"><i class="fa fa-check"></i></span>
                        <div class="color bg-pink"></div>
                        <div class="color-small bg-silver-100"></div>
                    </label>
                </div>
            </div>
        </div>
    </div>
    <!-- END THEME CONFIG PANEL-->
    <!-- BEGIN PAGA BACKDROPS-->
    <div class="sidenav-backdrop backdrop"></div>
    <div class="preloader-backdrop">
        <div class="page-preloader">Loading</div>
    </div>
    <!-- END PAGA BACKDROPS-->
    <!-- CORE PLUGINS-->
    <script src="./assets/vendors/jquery/dist/jquery.min.js" type="text/javascript"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js" type="text/javascript"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js" type="text/javascript"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js" type="text/javascript"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js" type="text/javascript"></script>
    <!-- PAGE LEVEL PLUGINS-->
    <script src="./assets/vendors/moment/min/moment.min.js" type="text/javascript"></script>
    <script src="./assets/vendors/fullcalendar/dist/fullcalendar.min.js" type="text/javascript"></script>
    <script src="./assets/vendors/jquery-ui/jquery-ui.min.js" type="text/javascript"></script>
    <!-- CORE SCRIPTS-->
    <script src="assets/js/app.min.js" type="text/javascript"></script>
    <!-- PAGE LEVEL SCRIPTS-->
    <script src="./assets/js/scripts/calendar-demo.js" type="text/javascript"></script>
</body>

</html>