<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
    <link rel="icon" href="../Media/logo.png" type="image/x-icon">

</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Sales Reports</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Sales Reports</li>
                </ol>

<!-- SALES REPORT SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Sales Report</div>
                    <div class="ibox-tools">
                        <a class="ibox-collapse"><i class="fa fa-minus"></i></a>
                        <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-v"></i></a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a class="dropdown-item">View Detailed Report</a>
                            <a class="dropdown-item">Download Report</a>
                        </div>
                    </div>
                </div>
                <div class="ibox-body">
                    <!-- FILTER BAR -->
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3">
                        <div class="mb-2 mb-md-0">
                            <button class="btn btn-primary"><i class="fa fa-calendar"></i> Select Date Range</button>
                        </div>
                        <div>
                            <select class="form-control w-auto">
                                <option>Sort by Sales Amount</option>
                                <option>Sort by Number of Orders</option>
                                <option>Sort by Date</option>
                            </select>
                        </div>
                    </div>

                    <!-- SALES SUMMARY -->
                    <div class="row mb-4">
                        <div class="col-md-4">
                            <div class="ibox ibox-light">
                                <div class="ibox-head">
                                    <div class="ibox-title">Total Sales</div>
                                </div>
                                <div class="ibox-body text-center">
                                    <h3 class="font-weight-bold">$15,230</h3>
                                    <span>for the selected period</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="ibox ibox-light">
                                <div class="ibox-head">
                                    <div class="ibox-title">Total Orders</div>
                                </div>
                                <div class="ibox-body text-center">
                                    <h3 class="font-weight-bold">1,532</h3>
                                    <span>total orders</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="ibox ibox-light">
                                <div class="ibox-head">
                                    <div class="ibox-title">Average Order Value</div>
                                </div>
                                <div class="ibox-body text-center">
                                    <h3 class="font-weight-bold">$9.95</h3>
                                    <span>per order</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- SALES DATA TABLE -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Product</th>
                                    <th>Category</th>
                                    <th>Total Sales</th>
                                    <th>Total Orders</th>
                                    <th>Average Order Value</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>Kenyan Coffee Beans</td>
                                    <td>Beverages</td>
                                    <td>$5,120</td>
                                    <td>450</td>
                                    <td>$11.38</td>
                                    <td>
                                        <button class="btn btn-sm btn-info" title="View Details">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>Handmade Wooden Bowl</td>
                                    <td>Kitchenware</td>
                                    <td>$3,500</td>
                                    <td>350</td>
                                    <td>$10.00</td>
                                    <td>
                                        <button class="btn btn-sm btn-info" title="View Details">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>3</td>
                                    <td>Maasai Shuka Blanket</td>
                                    <td>Textiles</td>
                                    <td>$2,800</td>
                                    <td>280</td>
                                    <td>$10.00</td>
                                    <td>
                                        <button class="btn btn-sm btn-info" title="View Details">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>4</td>
                                    <td>Handcrafted Jewelry Set</td>
                                    <td>Accessories</td>
                                    <td>$4,200</td>
                                    <td>320</td>
                                    <td>$13.13</td>
                                    <td>
                                        <button class="btn btn-sm btn-info" title="View Details">
                                            <i class="fa fa-eye"></i>
                                        </button>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- PAGINATION -->
                    <div class="mt-3 text-center">
                        <button class="btn btn-light">Previous</button>
                        <button class="btn btn-light">Next</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END SALES REPORT SECTION -->

<!-- RESPONSIVE STYLES -->
<style>
    @media (max-width: 768px) {
        .table-responsive {
            overflow-x: auto;
        }

        .btn {
            font-size: 12px;
            padding: 6px 10px;
        }

        .form-control {
            font-size: 14px;
        }

        .ibox-head {
            flex-wrap: wrap;
        }

        .badge {
            font-size: 12px;
            padding: 5px 8px;
        }
    }
</style>

            </div>

        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
