<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>RoamingNdovu | Dashboard</title>
    <!-- GLOBAL MAINLY STYLES-->
    <link href="./assets/vendors/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="./assets/vendors/font-awesome/css/font-awesome.min.css" rel="stylesheet" />
    <link href="./assets/vendors/themify-icons/css/themify-icons.css" rel="stylesheet" />
    <!-- THEME STYLES-->
    <link href="assets/css/main.min.css" rel="stylesheet" />
    <link rel="icon" href="../Media/logo.png" type="image/x-icon">

</head>

<body class="fixed-navbar">
    <div class="page-wrapper">
        <?php 
            include 'header-sidebar.php';
        ?>

        <div class="content-wrapper">
            <!-- START PAGE CONTENT-->
            <div class="page-heading">
                <h1 class="page-title">Stock</h1>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="index.html"><i class="la la-home font-20"></i></a>
                    </li>
                    <li class="breadcrumb-item">Stock</li>
                </ol>

               <!-- STOCK MANAGEMENT SECTION -->
<div class="page-content fade-in-up">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Stock Management</div>
                    <div class="ibox-tools">
                        <a class="ibox-collapse"><i class="fa fa-minus"></i></a>
                        <a class="dropdown-toggle" data-toggle="dropdown"><i class="fa fa-ellipsis-v"></i></a>
                        <div class="dropdown-menu dropdown-menu-right">
                            <a class="dropdown-item">Add New Stock</a>
                            <a class="dropdown-item">Update Stock</a>
                            <a class="dropdown-item">Delete Stock</a>
                        </div>
                    </div>
                </div>
                <div class="ibox-body">
                    <!-- ACTION BAR -->
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-3">
                        <div class="mb-2 mb-md-0">
                            <button class="btn btn-primary"><i class="fa fa-plus"></i> Add Stock</button>
                            <button class="btn btn-warning"><i class="fa fa-edit"></i> Update Stock</button>
                            <button class="btn btn-danger"><i class="fa fa-trash"></i> Delete Selected</button>
                        </div>
                        <div>
                            <select class="form-control w-auto">
                                <option>Sort by Product Name</option>
                                <option>Sort by Quantity</option>
                                <option>Sort by Date Added</option>
                            </select>
                        </div>
                    </div>

                    <!-- STOCK TABLE -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Product Name</th>
                                    <th>Category</th>
                                    <th>Stock Quantity</th>
                                    <th>Last Updated</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>1</td>
                                    <td>Kenyan Coffee Beans</td>
                                    <td>Beverages</td>
                                    <td>120</td>
                                    <td>02/01/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>2</td>
                                    <td>Handmade Wooden Bowl</td>
                                    <td>Kitchenware</td>
                                    <td>50</td>
                                    <td>02/02/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>3</td>
                                    <td>Maasai Shuka Blanket</td>
                                    <td>Textiles</td>
                                    <td>30</td>
                                    <td>02/03/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                                <tr>
                                    <td>4</td>
                                    <td>Handcrafted Jewelry Set</td>
                                    <td>Accessories</td>
                                    <td>80</td>
                                    <td>02/04/2025</td>
                                    <td>
                                        <button class="btn btn-sm btn-warning" title="Edit">
                                            <i class="fa fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" title="Delete">
                                            <i class="fa fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <!-- PAGINATION -->
                    <div class="mt-3 text-center">
                        <button class="btn btn-light">Previous</button>
                        <button class="btn btn-light">Next</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END STOCK MANAGEMENT SECTION -->

<!-- RESPONSIVE STYLES -->
<style>
    @media (max-width: 768px) {
        .table-responsive {
            overflow-x: auto;
        }
        
        .btn {
            font-size: 12px;
            padding: 6px 10px;
        }

        .form-control {
            font-size: 14px;
        }

        .ibox-head {
            flex-wrap: wrap;
        }
    }
</style>

            </div>

      
        </div>
    </div>

    <!-- SCRIPTS -->
    <script src="./assets/vendors/jquery/dist/jquery.min.js"></script>
    <script src="./assets/vendors/popper.js/dist/umd/popper.min.js"></script>
    <script src="./assets/vendors/bootstrap/dist/js/bootstrap.min.js"></script>
    <script src="./assets/vendors/metisMenu/dist/metisMenu.min.js"></script>
    <script src="./assets/vendors/jquery-slimscroll/jquery.slimscroll.min.js"></script>
    <script src="assets/js/app.min.js"></script>
</body>

</html>
