<?php
// /dashboard/admin/token_check.php

// Define the path to Auth.php
$authPath = __DIR__ . '/../../backend/classes/Auth.php';
if (!file_exists($authPath)) {
    die("Auth.php not found at: " . $authPath);
}
require_once $authPath;

// Debug token availability
$headers = getallheaders();
$tokenFromHeader = $headers['Authorization'] ?? 'Not set';
$tokenFromCookie = $_COOKIE['token'] ?? 'Not set';
error_log("Token from header: $tokenFromHeader, Token from cookie: $tokenFromCookie"); // Log for debugging

// Check if token is valid
function checkToken() {
    $headers = getallheaders();
    $token = $headers['Authorization'] ?? $_COOKIE['token'] ?? ''; // Prefer header, fallback to cookie

    if (!$token) {
        error_log("No token found, redirecting to login");
        header("Location:../../dashboard/admin/login.php");
        exit();
    }

    $auth = new Auth();
    $userId = $auth->validateToken($token);

    if (!$userId) {
        error_log("Invalid token: $token, redirecting to login");
        header("Location: ../../dashboard/admin/login.php");
        exit();
    }

    return $userId; // Return user ID for further use
}

// Call this at the top of protected pages
$userId = checkToken();
?>