// This script handles the login form validation and submission using jQuery and AJAX.
$(function() {
        $(document).ready(function() {
            $('#login-form').validate({
                errorClass: "help-block",
                rules: {
                    email: {
                        required: true,
                        email: true
                    },
                    password: {
                        required: true
                    }
                },
                highlight: function(e) {
                    $(e).closest(".form-group").addClass("has-error");
                },
                unhighlight: function(e) {
                    $(e).closest(".form-group").removeClass("has-error");
                },
                submitHandler: function(form) {
                    $.ajax({
                        url: '../../backend/api/v1/login.php', // Relative endpoint
                        type: 'POST',
                        data: JSON.stringify({
                            email: $('input[name="email"]').val(),
                            password: $('input[name="password"]').val()
                        }),
                        contentType: 'application/json',
                        success: function(response) {
                            console.log('Response:', response);
                            if (response.success && response.token) {
                                document.cookie = `token=${response.token}; path=/; max-age=3600; HttpOnly=false; SameSite=Lax`; // Ensure cookie is set
                                window.location.href = response.redirect || './index.php'; // Follow redirect instruction
                            } else if (response.error) {
                                $('#login-form').prepend('<p class="text-danger">' + response.error + '</p>');
                            }
                        },
                        error: function(xhr, status, error) {
                            console.log('Error:', xhr.status, status, error);
                            $('#login-form').prepend('<p class="text-danger">An error occurred. Please try again.</p>');
                        }
                    });
                    return false;
                }
            });
        });
});