document.querySelector('form').addEventListener('submit', async (e) => {
    e.preventDefault();

    // Get form values
    const first_name = document.querySelector('input[placeholder="First Name"]').value;
    const last_name = document.querySelector('input[placeholder="Last Name"]').value;
    const email = document.querySelector('input[placeholder="Email"]').value;
    const phone = document.querySelector('input[placeholder="Phone Number"]').value;
    const password = document.querySelector('#password').value;
    const confirmPassword = document.querySelector('#confirmPassword').value;

    // Step 1: Trim whitespace from all inputs
    const sanitizedData = {
        first_name: first_name.trim(),
        last_name: last_name.trim(),
        email: email.trim(),
        phone: phone.trim(),
        password: password.trim(),
    };

    // Step 2: Validate passwords match
    if (sanitizedData.password !== confirmPassword.trim()) {
        showMessage('Passwords do not match!', 'danger');
        return;
    }

    // Step 3: Validate email format
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(sanitizedData.email)) {
        showMessage('Please enter a valid email address!', 'danger');
        return;
    }

    // Step 4: Validate phone number (must be 10 digits, starting with 0)
    const phoneRegex = /^0[0-9]{9}$/;
    if (!phoneRegex.test(sanitizedData.phone)) {
        showMessage('Please enter a valid phone number (e.g., 0791333586)!', 'danger');
        return;
    }

    // Step 5: Validate password strength (e.g., minimum 8 characters, at least 1 letter, 1 number)
    const passwordRegex = /^(?=.*[A-Za-z])(?=.*\d)[A-Za-z\d@$!%*?&]{8,}$/;
    if (!passwordRegex.test(sanitizedData.password)) {
        showMessage('Password must be at least 8 characters long and contain at least one letter and one number!', 'danger');
        return;
    }

    // Step 6: Sanitize first_name and last_name to prevent XSS (remove HTML tags)
    const sanitizeString = (str) => {
        const div = document.createElement('div');
        div.textContent = str;
        return div.innerHTML; // Escapes HTML characters
    };

    sanitizedData.first_name = sanitizeString(sanitizedData.first_name);
    sanitizedData.last_name = sanitizeString(sanitizedData.last_name);

    // Step 7: Prepare the data to send
    const data = {
        first_name: sanitizedData.first_name,
        last_name: sanitizedData.last_name,
        email: sanitizedData.email,
        phone: sanitizedData.phone,
        password: sanitizedData.password,
    };

    try {
        const response = await fetch('./backend/users/register.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });

        // Log the raw response if it's not JSON
        if (!response.ok) {
            const text = await response.text();
            console.log('Raw response:', text);
            throw new Error('Network response was not ok');
        }

        const result = await response.json();

        if (result.success) {
            showMessage('Registration successful! Redirecting to login...', 'success');
            setTimeout(() => {
                window.location.href = 'login.php';
            }, 2000); // Redirect after 2 seconds
        } else {
            showMessage(result.message, 'danger');
        }
    } catch (error) {
        console.error('Error:', error);
        showMessage('An error occurred: ' + error.message, 'danger');
    }
});

// Function to show Bootstrap alert messages
function showMessage(message, type) {
    const messageContainer = document.createElement('div');
    messageContainer.className = `alert alert-${type} alert-dismissible fade show`;
    messageContainer.role = 'alert';
    messageContainer.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    `;

    // Remove any existing alerts
    const existingAlert = document.querySelector('.alert');
    if (existingAlert) {
        existingAlert.remove();
    }

    // Add the new alert above the form
    const form = document.querySelector('form');
    form.parentNode.insertBefore(messageContainer, form);
}document.querySelector('form').addEventListener('submit', async (e) => {
    e.preventDefault();

    // Get form values
    const first_name = document.querySelector('input[placeholder="First Name"]').value;
    const last_name = document.querySelector('input[placeholder="Last Name"]').value;
    const email = document.querySelector('input[placeholder="Email"]').value;
    const phone = document.querySelector('input[placeholder="Phone Number"]').value;
    const password = document.querySelector('#password').value;
    const confirmPassword = document.querySelector('#confirmPassword').value;

    // Step 1: Trim whitespace from all inputs
    const sanitizedData = {
        first_name: first_name.trim(),
        last_name: last_name.trim(),
        email: email.trim(),
        phone: phone.trim(),
        password: password.trim(),
    };

    // Step 2: Validate passwords match
    if (sanitizedData.password !== confirmPassword.trim()) {
        showMessage('Passwords do not match!', 'danger');
        return;
    }

    // Step 3: Validate email format
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(sanitizedData.email)) {
        showMessage('Please enter a valid email address!', 'danger');
        return;
    }

    // Step 4: Validate phone number (must be 10 digits, starting with 0)
    const phoneRegex = /^0[0-9]{9}$/;
    if (!phoneRegex.test(sanitizedData.phone)) {
        showMessage('Please enter a valid phone number (e.g., 0791333586)!', 'danger');
        return;
    }

    // Step 5: Validate password strength (minimum 8 characters, at least 1 letter, 1 number)
    const passwordRegex = /^(?=.*[A-Za-z])(?=.*\d).{8,}$/;
    if (!passwordRegex.test(sanitizedData.password)) {
        showMessage('Password must be at least 8 characters long and contain at least one letter and one number!', 'danger');
        return;
    }

    // Step 6: Sanitize first_name and last_name to prevent XSS (remove HTML tags)
    const sanitizeString = (str) => {
        const div = document.createElement('div');
        div.textContent = str;
        return div.innerHTML; // Escapes HTML characters
    };

    sanitizedData.first_name = sanitizeString(sanitizedData.first_name);
    sanitizedData.last_name = sanitizeString(sanitizedData.last_name);

    // Step 7: Prepare the data to send
    const data = {
        first_name: sanitizedData.first_name,
        last_name: sanitizedData.last_name,
        email: sanitizedData.email,
        phone: sanitizedData.phone,
        password: sanitizedData.password,
    };

    try {
        const response = await fetch('./backend/users/register.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify(data),
        });

        // Log the raw response if it's not JSON
        if (!response.ok) {
            const text = await response.text();
            console.log('Raw response:', text);
            throw new Error('Network response was not ok');
        }

        const result = await response.json();

        if (result.success) {
            showMessage('Registration successful! Redirecting to login...', 'success');
            setTimeout(() => {
                window.location.href = 'login.php';
            }, 2000); // Redirect after 2 seconds
        } else {
            showMessage(result.message, 'danger');
        }
    } catch (error) {
        console.error('Error:', error);
        showMessage('An error occurred: ' + error.message, 'danger');
    }
});

// Function to show Bootstrap alert messages
function showMessage(message, type) {
    const messageContainer = document.createElement('div');
    messageContainer.className = `alert alert-${type} alert-dismissible fade show`;
    messageContainer.role = 'alert';
    messageContainer.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    `;

    // Remove any existing alerts
    const existingAlert = document.querySelector('.alert');
    if (existingAlert) {
        existingAlert.remove();
    }

    // Add the new alert above the form
    const form = document.querySelector('form');
    form.parentNode.insertBefore(messageContainer, form);
}