-- Active: 1740738976506@@127.0.0.1@3306@test

DROP TABLE IF EXISTS `admins`;
CREATE TABLE `admins` (
  `admin_id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`admin_id`),
  UNIQUE KEY `email` (`email`)
) ;



INSERT INTO `admins` VALUES
(1,'admin@gmail.com','$2y$12$RXUHGuSM2okL3uzcUW6IJOycfO2.hMKOFCXMu2Exw9eeoIwJVJMz6','admin','admin','2025-03-01 00:00:00');


DROP TABLE IF EXISTS `cart`;


CREATE TABLE `cart` (
  `cart_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL CHECK (`quantity` > 0),
  `added_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`cart_id`),
  UNIQUE KEY `user_id` (`user_id`,`product_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `cart_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `cart_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ;





DROP TABLE IF EXISTS `categories`;


CREATE TABLE `categories` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`category_id`),
  UNIQUE KEY `name` (`name`)
) ;



INSERT INTO `categories` VALUES
(1,'test',NULL,'2025-03-02 09:01:07'),
(2,'biknkl','zsfvs','2025-03-02 16:53:54'),
(3,'rwgw','rsgrsv','2025-03-02 18:12:22');


DROP TABLE IF EXISTS `order_items`;


CREATE TABLE `order_items` (
  `order_item_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL CHECK (`quantity` > 0),
  `price` decimal(10,2) NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`order_id`),
  CONSTRAINT `order_items_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ;



INSERT INTO `order_items` VALUES
(1,1,1,3,300.00);


DROP TABLE IF EXISTS `orders`;


CREATE TABLE `orders` (
  `order_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `total_amount` decimal(10,2) NOT NULL,
  `status` enum('pending','processing','shipped','delivered','cancelled') DEFAULT 'pending',
  `shipping_address` text NOT NULL,
  `billing_address` text DEFAULT NULL,
  `payment_method` varchar(50) NOT NULL,
  `payment_status` enum('pending','paid','failed') DEFAULT 'pending',
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`order_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `orders_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ;



INSERT INTO `orders` VALUES
(1,1,300.00,'pending','ergrg','waegv','mpesa','paid','2025-03-02 07:44:11',NULL),
(2,1,33.00,'pending','weg',NULL,'efwe','pending','2025-03-02 08:54:13',NULL);


DROP TABLE IF EXISTS `product_images`;


CREATE TABLE `product_images` (
  `image_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `image_url` varchar(255) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`image_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `product_images_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ;



INSERT INTO `product_images` VALUES
(1,2,'/dashboard/admin/uploads/HD-wallpaper-anime-aesthetic-black-anume (1).jpg','2025-03-02 18:11:32'),
(2,2,'/dashboard/admin/uploads/HD-wallpaper-black-panther-black-panther-marvel-thumbnail.jpg','2025-03-02 18:11:32'),
(3,2,'/dashboard/admin/uploads/HD-wallpaper-spider-black-blue-game-hero-logo-movie-spiderman-super-super-hero.jpg','2025-03-02 18:11:32'),
(4,2,'/dashboard/admin/uploads/HD-wallpaper-spiderman-dark-marvels-black.jpg','2025-03-02 18:11:32'),
(5,3,'/dashboard/admin/uploads/HD-wallpaper-spiderman-dark-marvels-black.jpg','2025-03-02 18:13:09'),
(6,3,'/dashboard/admin/uploads/HD-wallpaper-spider-black-blue-game-hero-logo-movie-spiderman-super-super-hero.jpg','2025-03-02 18:13:09'),
(7,4,'/dashboard/admin/uploads/HD-wallpaper-devil-angel-black-boy-iphone-love-lucifer-play-boy-sad-wing.jpg','2025-03-02 18:21:55'),
(8,4,'/dashboard/admin/uploads/HD-wallpaper-love-ludo-game-naseeb.jpg','2025-03-02 18:21:55'),
(9,4,'/dashboard/admin/uploads/HD-wallpaper-spider-man-amoled-black-comics-hero-into-spider-the-verse.jpg','2025-03-02 18:21:55'),
(10,4,'/dashboard/admin/uploads/HD-wallpaper-black-hacker-darkness-blueeyes-cool-horrible-thumbnail.jpg','2025-03-02 18:21:55'),
(11,5,'/dashboard/admin/uploads/Screenshot From 2025-02-25 14-07-24.png','2025-03-02 18:31:43'),
(12,5,'/dashboard/admin/uploads/Screenshot From 2025-02-25 23-57-05.png','2025-03-02 18:31:43'),
(13,5,'/dashboard/admin/uploads/Screenshot From 2025-02-26 13-08-11.png','2025-03-02 18:31:43'),
(14,5,'/dashboard/admin/uploads/Screenshot From 2025-02-28 23-38-17.png','2025-03-02 18:31:43');


DROP TABLE IF EXISTS `product_reviews`;


CREATE TABLE `product_reviews` (
  `review_id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `rating` tinyint(4) NOT NULL CHECK (`rating` between 1 and 5),
  `review_text` text DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`review_id`),
  KEY `product_id` (`product_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `product_reviews_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`),
  CONSTRAINT `product_reviews_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`)
) ;





DROP TABLE IF EXISTS `products`;


CREATE TABLE `products` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `vendor_id` int(11) DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `stock` int(11) NOT NULL,
  `primary_image` varchar(255) NOT NULL,
  `category_id` int(11) NOT NULL,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `review_count` int(11) DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`product_id`),
  KEY `vendor_id` (`vendor_id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `products_ibfk_1` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`vendor_id`),
  CONSTRAINT `products_ibfk_2` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`)
) ;



INSERT INTO `products` VALUES
(1,NULL,'testing','etetw',230.00,22,'rttw',1,0.00,0,'2025-03-02 09:02:03',NULL,0),
(2,NULL,'black panther','sample description',33.00,44,'/dashboard/admin/uploads/HD-wallpaper-black-panther-avengers-dark-infinity-logo-marvel-war.jpg',3,0.00,0,'2025-03-02 18:11:32',NULL,1),
(3,6,'ewgwe','zrr',6756.00,234,'/dashboard/admin/uploads/HD-wallpaper-black-panther-black-panther-marvel-thumbnail.jpg',3,0.00,0,'2025-03-02 18:13:09',NULL,1),
(4,NULL,'testing','fdhd',333.00,6,'/dashboard/admin/uploads/HD-wallpaper-arc-reactor-circuit-computer-geometry-inside-magic-sacred-science-tech-technology-tron.jpg',2,0.00,0,'2025-03-02 18:21:55',NULL,1),
(5,7,'wet castde','dtdfb',34.00,44,'/dashboard/admin/uploads/Screenshot From 2025-02-25 13-33-29.png',2,0.00,0,'2025-03-02 18:31:43',NULL,0);


DROP TABLE IF EXISTS `sales`;


CREATE TABLE `sales` (
  `sale_id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` int(11) NOT NULL,
  `vendor_id` int(11) DEFAULT NULL,
  `product_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `total` decimal(10,2) NOT NULL,
  `sale_date` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`sale_id`),
  KEY `order_id` (`order_id`),
  KEY `vendor_id` (`vendor_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `sales_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `orders` (`order_id`),
  CONSTRAINT `sales_ibfk_2` FOREIGN KEY (`vendor_id`) REFERENCES `vendors` (`vendor_id`),
  CONSTRAINT `sales_ibfk_3` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ;





DROP TABLE IF EXISTS `tokens`;


CREATE TABLE `tokens` (
  `token_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `token` varchar(64) NOT NULL,
  `expires_at` datetime NOT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`token_id`),
  UNIQUE KEY `token` (`token`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `tokens_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE
) ;



INSERT INTO `tokens` VALUES
(1,1,'e41a9d7aec350e30d59edc93104538b57c81dc9c1f8618e4fd68e845237ca914','2025-03-01 22:25:41','2025-03-02 00:25:41'),
(2,1,'ce21261ad4b9c41a54f07605eef62ca496e1379ed331966e102190c24dfb31b3','2025-03-01 22:26:42','2025-03-02 00:26:42'),
(3,1,'b3e4a2d1e1eb53025fa9300b85d4d479e446a69dbb5502b12f0b7de5691e47ce','2025-03-01 23:41:59','2025-03-02 01:41:59'),
(4,1,'e468e3cfef9ee6bbce143341caff3898f60b83ebf518e55d83e4ba4e91bf0a3e','2025-03-01 23:47:30','2025-03-02 01:47:30'),
(5,1,'2d643c8436b177db55c48d12d3a4ed8f53d049447414c186683e8d84f6afc12c','2025-03-01 23:50:00','2025-03-02 01:50:00'),
(6,1,'810d3cf2286f96af93a12be2f82923e7de1b0012cd84c7f9722bc13d8239a453','2025-03-01 23:55:52','2025-03-02 01:55:52'),
(7,1,'84837c20fd49a4a4e84fe5762b2b24b5ea9bd9c5786f51fed228144d409ab4d8','2025-03-02 00:00:13','2025-03-02 02:00:13'),
(8,1,'f56bbc9943e65cbb9d1ec951a57dd91b462122ccbe810483990767551ef3d1d9','2025-03-02 00:01:16','2025-03-02 02:01:16'),
(9,1,'614097ba6c6f64cb466473745c3082ec984203d0ac279a345614716b04fafb1d','2025-03-02 00:10:03','2025-03-02 02:10:03'),
(10,1,'fbeb8de2e2eb1ee6f963bdea287beba392ceabf1dd4f846a5537f6673950942b','2025-03-02 00:10:18','2025-03-02 02:10:18'),
(11,1,'841cf35b69bd0f6dded1b994325b13e3779f785bd711931f23125b223ced87f1','2025-03-02 00:13:39','2025-03-02 02:13:39'),
(12,1,'e0abb4de21546baa09c764cb174acfcc7c6cfab628b152aea1dd47946322eba3','2025-03-02 00:13:47','2025-03-02 02:13:47'),
(13,1,'2d4c5ef75367702b6301e364fdd801ce44b0d43a04129d182f1d18bbe3fe313d','2025-03-02 00:19:09','2025-03-02 02:19:09'),
(14,1,'aeb7e240c04de393e4f8375d2b383901c3eca6c563ac6497a0c34185a16847d8','2025-03-02 00:23:48','2025-03-02 02:23:48'),
(15,1,'e1911d13ba949dc7443f0432f3ebda8592881393e855dcd835dce2ecf8a6a8b5','2025-03-02 00:29:04','2025-03-02 02:29:04'),
(16,1,'11eac8b086c587f88f86236b508dff45bcf492120c868c3411d42eef2064a946','2025-03-02 00:33:13','2025-03-02 02:33:13'),
(17,1,'5a20251e674553dd04f02f70aa760e85536e44722d379943e21b145393b48bcf','2025-03-02 00:33:47','2025-03-02 02:33:47'),
(18,1,'52d23cf0cf50f074298b37267dbf4f81421eee11eb2e174a189ac174b31bac0e','2025-03-02 00:40:50','2025-03-02 02:40:50'),
(19,1,'8cb23d519dcfadb84303b1d1b9b22eb80168fa528fa5e1e0fc34202610eb5398','2025-03-02 01:06:42','2025-03-02 03:06:42'),
(20,1,'c251f9e14520ab6341aa7d8d0e022b3109c97085d9024dd223d13d39c33f83fc','2025-03-02 01:10:41','2025-03-02 03:10:41'),
(21,1,'86f01085b5eb31c5f2266f237749d36b932f51c4be92c5b709d5029d0b8328b0','2025-03-02 05:44:27','2025-03-02 07:44:27'),
(22,1,'afb08f894fa1debb1cb1f447b1d4598e0d19bf4ac253fa731e7ee1d49cea3d99','2025-03-02 05:59:49','2025-03-02 07:59:49'),
(23,1,'56d2b8539e31edf9623a867f47a317040761ad5ec0d3d135a2ccc751283188a7','2025-03-02 06:00:47','2025-03-02 08:00:47'),
(24,1,'41f17b7a3e958f4bc61c908cac3b0b08e163a5cb653628b3eb2251039b753627','2025-03-02 06:11:59','2025-03-02 08:11:59'),
(25,1,'f9961fa8f91fc3fbb60b6f1895cd738fd982bd0dbab9392a319413d6037a4e8b','2025-03-02 06:12:48','2025-03-02 08:12:48'),
(26,1,'e9e7c2df61cdeb63cc9c40ee875f4c7b6b2d2f629399140d8b3ab420b53d7033','2025-03-02 06:15:10','2025-03-02 08:15:10'),
(27,1,'a2e974d1021a22d9f46d2951fc97962f9aafd8704ce5f307e068e3a0cd547c61','2025-03-02 07:15:35','2025-03-02 09:15:35'),
(28,1,'590f41dcf12b8e35480865ad73add86888f80fbdb5d880406e93717f8d5086a2','2025-03-02 07:39:32','2025-03-02 09:39:32'),
(29,1,'61e726a33fddcb1b4442f5a71666f3925a97599ac3a4a2d8e8f69e0adce26785','2025-03-02 07:51:35','2025-03-02 09:51:35'),
(32,4,'babe2f36f0ac16df1cc392fd4efa4f9f973b9608763347bb8aa57960f91d8be3','2025-03-02 09:01:20','2025-03-02 11:01:20'),
(36,1,'fe9a2c0e5e8b29edea5892d650846bb52fdef80a12f5a91edc8c7bd72aa4e5f3','2025-03-02 09:34:12','2025-03-02 11:34:12'),
(39,4,'020f5bf6dcd81410db57d137756ef3408044ba43b28c02a12450b3b740334971','2025-03-02 09:50:46','2025-03-02 11:50:46'),
(40,1,'0de4e4acc94ff97e5a27850ddf0a87bed837669390a06cbeb1befef1a3454d88','2025-03-02 10:51:16','2025-03-02 12:51:16'),
(41,1,'6b6bb68fcdac956af5415be52111302a9a67aa47869a69b4adaa5e10a7ae2f13','2025-03-02 11:58:54','2025-03-02 13:58:54'),
(43,4,'1172f6dfdfec4d2126c77ff4ab4d439da59733c4b761675f6ae5ab161d1e1172','2025-03-02 13:36:01','2025-03-02 15:36:01'),
(44,1,'23963b4a4eb7387732ae6db9f0e0faaf5d0e8730c16aceea1bcb53c1a5e2db9d','2025-03-02 14:10:29','2025-03-02 16:10:29'),
(45,4,'bf4f9201d7a2273786f1073f667e49c3acd80ee40383a3044998ee525e2027dc','2025-03-02 14:44:58','2025-03-02 16:44:58'),
(46,1,'e716c0f452473e56cad533cae6e0fcd2d161cbbc266aee2bba7cfe35088861dc','2025-03-02 15:13:09','2025-03-02 17:13:09'),
(47,1,'53553ebe48b08b55f8547c9fd1c7aa3aadc1c429ed5c76c2bcc500962eb77278','2025-03-02 15:28:18','2025-03-02 17:28:18'),
(48,1,'ed9d88ba30673bd7423af6fc08d4de3a58d4492802d3bb70df352ebe67a4ede9','2025-03-02 15:28:31','2025-03-02 17:28:31'),
(49,1,'e72251017d718d6034be43d0f96dcdac60c8a63f547806b43934f7787af8d4cd','2025-03-02 15:28:32','2025-03-02 17:28:32'),
(50,1,'e90b64fe4b50e50442bdb113e71ea9b93c0543887c296edb244b1851ed2dfd9f','2025-03-02 15:28:32','2025-03-02 17:28:32'),
(51,1,'ee0d8a441ce2643389b6f7c0f97ecb26ecd8d21583539bce819bf17c8107ca8c','2025-03-02 15:28:32','2025-03-02 17:28:32'),
(52,1,'2d2b0c9d1f1f497c620d23524c535422c335b5c2755eeefdafdec6d5bd690103','2025-03-02 15:28:33','2025-03-02 17:28:33'),
(53,1,'2862fbe28586c0d9a98fb984b6c424d6d208de801ce0e410bb8ef513a23e4ad1','2025-03-02 15:28:33','2025-03-02 17:28:33'),
(54,1,'d9c440ae70c723d0d9f76443313176ac80ba9bd8da80fe0fbc764130c7db088e','2025-03-02 15:28:34','2025-03-02 17:28:34'),
(56,1,'958bd17e79c3c3698b8d82d4e647d92e24f812e1e2addbfac3107b0406687121','2025-03-02 15:49:32','2025-03-02 17:49:32'),
(57,1,'ea649ec9f24f90bf1cfa5738d472334ba11a7897e6fbd8f62197dc9a00e5ec02','2025-03-02 16:57:58','2025-03-02 18:57:58'),
(58,1,'c98640fedf5941554cb141d89677f47c7fbe80ab8a2501c60d65a8d5916b8c21','2025-03-02 20:40:09','2025-03-02 22:40:09'),
(59,1,'3827e82caa5a185db2dfc0b6027ec9dc9f2cc274197ef35d0849fb32634e0e0d','2025-03-02 22:11:46','2025-03-03 00:11:46'),
(60,1,'1943ee8269efac884d9993f35ece003a56ee2dfc4ffb483e88f9d074095d82f7','2025-03-02 23:13:51','2025-03-03 01:13:51');


DROP TABLE IF EXISTS `users`;


CREATE TABLE `users` (
  `user_id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `first_name` varchar(100) NOT NULL,
  `last_name` varchar(100) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `updated_at` datetime DEFAULT NULL,
  `role` enum('user','vendor','admin') DEFAULT 'user',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `email` (`email`)
) ;



INSERT INTO `users` VALUES
(1,'admin@gmail.com','$2y$12$RXUHGuSM2okL3uzcUW6IJOycfO2.hMKOFCXMu2Exw9eeoIwJVJMz6','admin','admin','081322411','2025-03-01 00:00:00',NULL,'admin'),
(3,'customerrr@gmail.com','$2y$12$5aXw/cLE36irdVxRSlFFNuoMzwrDe36/URtcaACUsRUB7fylKH7ka','Lloyd','Katila','0739592499','2025-03-02 10:51:26',NULL,'user'),
(4,'admin2@gmail.com','$2y$12$TX9.kJAihY7WO/wxF/D4EunCC6uMfn6HxqP8bqcLjbQY.87qT.Xiy','Lloyd','Katila','0739592478','2025-03-02 10:53:39',NULL,'admin'),
(8,'vendor@gmail.com','$2y$12$g9QYsZpt6BUnlFtp1n.HI.lAuw.puMZsyuOS03HcDv3ztMp5fgUcq','Lloyd','Katila','0739592498','2025-03-02 12:08:10',NULL,'vendor'),
(10,'vendor22@gmail.com','$2y$12$diA52DgYN80H7ONq3ydLX.CpTNfAumftG0aDGOl.2S3qDHb3RwlgS','Lloyd','Katila','0739592342','2025-03-02 12:17:17',NULL,'vendor'),
(12,'customer3@gmail.com','$2y$12$6Ayuf7LkGh91EwkNn49hA.MFOf6LXh.wqCCYWf8/1MGm8SI7v2at.','Lloyd','Katila','0739591212','2025-03-02 12:25:33',NULL,'user'),
(15,'gvendor4@gmail.com','$2y$12$rXjiaXob6W6LMxWOz.upBObCMiG12LTOkflnGbAnmnNxvrATWDng.','Lloyd','Katila','23456789876','2025-03-02 15:05:54',NULL,'vendor'),
(16,'g@gmail.com','$2y$12$hPpLASp9tIYJuQlBWBTLqOCIzozSWZtAyzhQkFQpRCYEPN5LXfa22','Gau','Otara','0791958185','2025-03-02 17:32:38',NULL,'admin'),
(17,'roaming@gmail.com','$2y$12$P76z0CflVS.dXCr7pWBHHuDZ.zKmdEqlUu0NzZIFELQpMyP3NQ3Di','Roaming ','Ndovu','0791958184','2025-03-02 17:33:46',NULL,'vendor'),
(18,'nswer@gmail.com','$2y$12$ZoayoKql4tlZBUqhbzXMB.5gVChnYjU43yqgfWVQMBLds4.H7HQFK','Nswer','Barbie','0791954985','2025-03-02 17:36:07',NULL,'vendor');


DROP TABLE IF EXISTS `vendors`;


CREATE TABLE `vendors` (
  `vendor_id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `vendor_name` varchar(100) NOT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `created_by` int(2) DEFAULT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  `approved` tinyint(1) DEFAULT 0,
  `bio` text DEFAULT NULL,
  `is_active` tinyint(1) DEFAULT 1,
  PRIMARY KEY (`vendor_id`)
) ;



INSERT INTO `vendors` VALUES
(2,'vendor@gmail.com','$2y$12$g9QYsZpt6BUnlFtp1n.HI.lAuw.puMZsyuOS03HcDv3ztMp5fgUcq','informatics electronics','0739592498',8,'2025-03-02 12:08:10',0,'dvsa',1),
(3,'vendor2@gmail.com','$2y$12$diA52DgYN80H7ONq3ydLX.CpTNfAumftG0aDGOl.2S3qDHb3RwlgS','informatics electronics','0739592342',10,'2025-03-02 12:17:17',0,'ytdyfgui oyilhl',1),
(4,'admin3@gmail.com','$2y$12$5jCoFqj9SUaGo1PNq8WNs.HjzqARMHUwUXvyTKsugyt2LeBJG61iK','informatics electronics','1234567890',4,'2025-03-02 12:22:44',0,'kfukgvhvm',1),
(5,'gvendor4@gmail.com','$2y$12$rXjiaXob6W6LMxWOz.upBObCMiG12LTOkflnGbAnmnNxvrATWDng.','informatics electronics','23456789876',15,'2025-03-02 15:05:54',0,'awrestdyfugihojk',1),
(6,'roaming@gmail.com','$2y$12$P76z0CflVS.dXCr7pWBHHuDZ.zKmdEqlUu0NzZIFELQpMyP3NQ3Di','Kilimall','0791958184',17,'2025-03-02 17:33:46',0,'jguguk',1),
(7,'nswer@gmail.com','$2y$12$ZoayoKql4tlZBUqhbzXMB.5gVChnYjU43yqgfWVQMBLds4.H7HQFK','Nswer NMIXX','0791954985',18,'2025-03-02 17:36:07',0,'JJGUTUFUYDFUY',1);


DROP TABLE IF EXISTS `wishlist`;


CREATE TABLE `wishlist` (
  `wishlist_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `added_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`wishlist_id`),
  UNIQUE KEY `user_id` (`user_id`,`product_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `wishlist_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`),
  CONSTRAINT `wishlist_ibfk_2` FOREIGN KEY (`product_id`) REFERENCES `products` (`product_id`)
) ;

