        $(document).ready(function() {
            // Initialize DataTable
            $('#usersTable').DataTable({
                pageLength: 10,
                responsive: true,
                "order": [[0, "asc"]], // Sort by # column ascending by default
                "searching": true, // Enable search
                "dom": '<"top"lf>rt<"bottom"ip>', // Custom layout with length, filter, table, info, pagination
                "language": {
                    "search": "Search:"
                }
            });

            // Live search functionality
            $('#searchInput').on('keyup', function() {
                $('#usersTable').DataTable().search(this.value).draw();
            });

            // Get token from PHP variable $tokenFromCookie
            const token = "<?php echo htmlspecialchars($tokenFromCookie ?? '', ENT_QUOTES, 'UTF-8'); ?>";
            if (!token) {
                console.error('Token not found');
                alert('Authentication token not found. Please log in again.');
                return;
            }
            console.log('Token retrieved:', token); // Debug log

            // View functionality
            $('.view-btn').on('click', function() {
                const userId = $(this).data('id');
                $.ajax({
                    url: '/api/v1/users?id=' + userId,
                    method: 'GET',
                    headers: { 'Authorization': token },
                    success: function(response) {
                        console.log('View response:', response); // Debug log
                        if (!response || typeof response !== 'object') {
                            alert('Invalid user data received');
                            return;
                        }
                        $('#viewEmail').text(response.email || 'N/A');
                        $('#viewFirstName').text(response.first_name || 'N/A');
                        $('#viewLastName').text(response.last_name || 'N/A');
                        $('#viewPhone').text(response.phone || 'N/A');
                        $('#viewRole').text(response.role || 'N/A');
                        if (response.role === 'vendor') {
                            $.ajax({
                                url: '../../backend/api/v1/vendors?email=' + encodeURIComponent(response.email),
                                method: 'GET',
                                headers: { 'Authorization': token },
                                success: function(vendorResponse) {
                                    console.log('Vendor response:', vendorResponse); // Debug log
                                    if (vendorResponse && typeof vendorResponse === 'object') {
                                        $('.vendor-fields-view').show();
                                        $('#viewVendorName').text(vendorResponse.vendor_name || 'N/A');
                                        $('#viewBio').text(vendorResponse.bio || 'N/A');
                                    } else {
                                        console.error('Invalid vendor data:', vendorResponse);
                                        $('.vendor-fields-view').hide();
                                    }
                                },
                                error: function(xhr) {
                                    console.error('Failed to fetch vendor details:', xhr.status, xhr.responseText);
                                    $('.vendor-fields-view').hide();
                                }
                            });
                        } else {
                            $('.vendor-fields-view').hide();
                        }
                        $('#viewModal').modal('show');
                    },
                    error: function(xhr) {
                        console.error('View AJAX error:', xhr.status, xhr.responseText);
                        alert('Failed to load user details: ' + xhr.responseText);
                    }
                });
            });

            // Edit functionality
            $('.edit-btn').on('click', function() {
                const userId = $(this).data('id');
                $.ajax({
                    url: '/api/v1/users?id=' + userId,
                    method: 'GET',
                    headers: { 'Authorization': token },
                    success: function(response) {
                        console.log('Edit response:', response); // Debug log
                        if (!response || typeof response !== 'object') {
                            alert('Invalid user data received');
                            return;
                        }
                        $('#editUserId').val(response.user_id);
                        $('#editEmail').val(response.email || '').attr('placeholder', response.email || 'Enter email');
                        $('#editPassword').val('').attr('placeholder', 'Enter new password (optional)');
                        $('#editFirstName').val(response.first_name || '').attr('placeholder', response.first_name || 'Enter first name');
                        $('#editLastName').val(response.last_name || '').attr('placeholder', response.last_name || 'Enter last name');
                        $('#editPhone').val(response.phone || '').attr('placeholder', response.phone || 'Enter phone number');
                        $('#editRole').val(response.role || 'user');
                        if (response.role === 'vendor') {
                            $.ajax({
                                url: '../../backend/api/v1/vendors?email=' + encodeURIComponent(response.email),
                                method: 'GET',
                                headers: { 'Authorization': token },
                                success: function(vendorResponse) {
                                    console.log('Vendor edit response:', vendorResponse); // Debug log
                                    if (vendorResponse && typeof vendorResponse === 'object') {
                                        $('.vendor-fields').show();
                                        $('#editVendorName').val(vendorResponse.vendor_name || '').attr('placeholder', vendorResponse.vendor_name || 'Enter vendor name');
                                        $('#editBio').val(vendorResponse.bio || '').attr('placeholder', vendorResponse.bio || 'Enter bio (optional)');
                                    } else {
                                        console.error('Invalid vendor data:', vendorResponse);
                                        $('.vendor-fields').hide();
                                    }
                                },
                                error: function(xhr) {
                                    console.error('Failed to fetch vendor details:', xhr.status, xhr.responseText);
                                    $('.vendor-fields').hide();
                                }
                            });
                        } else {
                            $('.vendor-fields').hide();
                        }
                        $('#editModal').modal('show');
                    },
                    error: function(xhr) {
                        console.error('Edit AJAX error:', xhr.status, xhr.responseText);
                        alert('Failed to load user details: ' + xhr.responseText);
                    }
                });
            });

            // Save Edit
            $('#saveEdit').on('click', function() {
                const userId = $('#editUserId').val();
                const data = {
                    email: $('#editEmail').val(),
                    password: $('#editPassword').val() || undefined, // Only send if changed
                    first_name: $('#editFirstName').val(),
                    last_name: $('#editLastName').val(),
                    phone: $('#editPhone').val(),
                    role: $('#editRole').val()
                };
                if ($('#editRole').val() === 'vendor' && $('.vendor-fields').is(':visible')) {
                    data.vendor_name = $('#editVendorName').val();
                    data.bio = $('#editBio').val();
                }
                $.ajax({
                    url: '../../backend/api/v1/users?id=' + userId,
                    method: 'PUT',
                    headers: { 'Authorization': token, 'Content-Type': 'application/json' },
                    data: JSON.stringify(data),
                    success: function(response) {
                        alert(response.message || 'User updated successfully');
                        location.reload(); // Reload to reflect changes
                    },
                    error: function(xhr) {
                        console.error('Update AJAX error:', xhr.status, xhr.responseText);
                        alert('Failed to update user: ' + xhr.responseText);
                    }
                });
                $('#editModal').modal('hide');
            });

            // Delete functionality
            $('.delete-btn').on('click', function() {
                const userId = $(this).data('id');
                $('#deleteUserId').val(userId);
                $('#deleteModal').modal('show');
            });

            $('#confirmDelete').on('click', function() {
                const userId = $('#deleteUserId').val();
                $.ajax({
                    url: '../../backend/api/v1/users.php?id=' + userId,
                    method: 'DELETE',
                    headers: { 'Authorization': token },
                    success: function(response) {
                        alert(response.message || 'User deleted successfully');
                        location.reload(); // Reload to reflect changes
                    },
                    error: function(xhr) {
                        console.error('Delete AJAX error:', xhr.status, xhr.responseText);
                        if (xhr.status === 405) {
                            // Workaround for 405: Try POST with a delete action
                            $.ajax({
                                url: '/api/v1/users?id=' + userId,
                                method: 'POST',
                                headers: { 'Authorization': token, 'Content-Type': 'application/json' },
                                data: JSON.stringify({ action: 'delete' }),
                                success: function(response) {
                                    alert(response.message || 'User deleted successfully');
                                    location.reload();
                                },
                                error: function(xhr) {
                                    console.error('POST delete workaround error:', xhr.status, xhr.responseText);
                                    alert('Failed to delete user: ' + xhr.responseText);
                                }
                            });
                        } else {
                            alert('Failed to delete user: ' + xhr.responseText);
                        }
                    }
                });
                $('#deleteModal').modal('hide');
            });

            // Show/hide vendor fields based on role
            $('#editRole').on('change', function() {
                if ($(this).val() === 'vendor') {
                    $('.vendor-fields').show();
                } else {
                    $('.vendor-fields').hide();
                }
            });
        });
    