<?php
session_start();

// Include database connection
require_once '../backend/config/database.php';

// Check if user is authenticated
if (!isset($_SESSION['user_id'])) {
    header('Location: ../login.php');
    exit;
}

$userId = $_SESSION['user_id'];

// Validate product_id
if (!isset($_GET['product_id']) || !is_numeric($_GET['product_id'])) {
    header('Location: index.php?error=Invalid product ID');
    exit;
}

$productId = (int)$_GET['product_id'];

// Add to wishlist
$db = new DatabaseConfig();
$conn = $db->getConnection();

try {
    // Check if the product is already in the user's wishlist
    $stmt = $conn->prepare("SELECT wishlist_id FROM wishlist WHERE user_id = :user_id AND product_id = :product_id");
    $stmt->execute([
        'user_id' => $userId,
        'product_id' => $productId
    ]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($existing) {
        // Product is already in the wishlist
        header("Location: index.php?message=Product already in wishlist&scroll_to=$productId");
        exit;
    }

    // Insert new wishlist entry
    $stmt = $conn->prepare(
        "INSERT INTO wishlist (user_id, product_id, added_at) 
        VALUES (:user_id, :product_id, NOW())"
    );
    $stmt->execute([
        'user_id' => $userId,
        'product_id' => $productId
    ]);

    // Redirect back to index.php with scroll_to parameter
    header("Location: index.php?message=Added to wishlist successfully&scroll_to=$productId");
    exit;
} catch (PDOException $e) {
    error_log("Failed to add to wishlist: " . $e->getMessage());
    header("Location: index.php?error=Failed to add to wishlist&scroll_to=$productId");
    exit;
}
?>