<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Roaming Ndovu | Store</title>
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="shortcut icon" href="../Media/logo.png" type="image/png">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/owl.theme.default.min.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .header-top-banner{
            background-color: green;
        }
    </style>
</head>

<body>
    
<?php include "./header.php"; ?>

<!--content-->
<div class="container container-240">
        <div class="checkout">
            <ul class="breadcrumb v3">
                <li><a href="./">Home</a></li>
                <li class="active">Cart</li>
            </ul>
            <div class="row">
                <div class="col-md-8 col-sm-12 col-xs-12">
                    <div class="shopping-cart bd-7">
                        <div class="cmt-title text-center abs">
                            <h1 class="page-title v2">Cart</h1>
                        </div>
                        <?php if (empty($cartItems)): ?>
                            <div class="empty-cart-message">
                                <p>Your cart is empty. <a href="index.php">Start shopping now!</a></p>
                            </div>
                        <?php else: ?>
                            <form method="post" action="cart.php">
                                <div class="table-responsive">
                                    <table class="table cart-table">
                                        <tbody>
                                            <?php foreach ($cartItems as $item): ?>
                                                <tr class="item_cart">
                                                    <td class="product-name flex align-center">
                                                        <a href="remove_from_cart.php?cart_id=<?php echo htmlspecialchars($item['cart_id']); ?>" class="btn-del"><i class="ion-ios-close-empty"></i></a>
                                                        <div class="product-img">
                                                            <img src="<?php echo "../".htmlspecialchars($item['primary_image']); ?>" alt="<?php echo htmlspecialchars($item['name']); ?>">
                                                        </div>
                                                        <div class="product-info">
                                                            <a href="single_product.php?id=<?php echo htmlspecialchars($item['product_id']); ?>" title=""><?php echo htmlspecialchars($item['name']); ?></a>
                                                        </div>
                                                    </td>
                                                    <td class="bcart-quantity single-product-detail">
                                                        <div class="single-product-info">
                                                            <div class="e-quantity">
                                                                <input type="number" step="1" min="1" max="999" name="quantity[<?php echo htmlspecialchars($item['cart_id']); ?>]" value="<?php echo htmlspecialchars($item['quantity']); ?>" title="Qty" class="qty input-text js-number" size="4">
                                                                <!-- <div class="tc pa">
                                                                    <a class="js-plus quantity-right-plus"><i class="fa fa-caret-up"></i></a>
                                                                    <a class="js-minus quantity-left-minus"><i class="fa fa-caret-down"></i></a>
                                                                </div> -->
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="total-price">
                                                        <p class="price">$<?php echo number_format($item['price'] * $item['quantity'], 2); ?></p>
                                                    </td>
                                                </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                                <div class="table-cart-bottom">
                                    <form class="form_coupon" action="#" method="post">
                                        <input type="email" value="" placeholder="Coupon code" name="EMAIL" id="mail" class="newsletter-input form-control">
                                        <div class="input-icon">
                                            <img src="img/coupon-icon.png" alt="">
                                        </div>
                                        <button id="subscribe2" class="button_mini btn" type="submit">
                                            Apply coupon
                                        </button>
                                    </form>
                                    <button type="submit" name="update_cart" class="btn btn-update">Update cart</button>
                                </div>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-md-4 col-sm-12 col-xs-12">
                    <div class="cart-total bd-7">
                        <div class="cmt-title text-center abs">
                            <h1 class="page-title v3">Cart totals</h1>
                        </div>
                        <div class="table-responsive">
                            <table class="shop_table">
                                <tbody>
                                    <tr class="cart-subtotal">
                                        <th>Subtotal</th>
                                        <td>$<?php echo number_format($subtotal, 2); ?></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="cart-total-bottom">
                            <a href="checkout.php" class="btn-gradient btn-checkout">Proceed to checkout</a>
                        </div>
                        <div class="sign-in-divider">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- / end content -->
    <footer>
        <div class="f-top">
            <div class="container container-240">
                <div class="row">
                    <div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
                        <div class="footer-block footer-about">
                            <ul class="footer-block-content">
                                <li class="address">
                                    <span>Nairobi, Kenya</span>
                                </li>
                                <li class="phone">
                                    <span>(+123) 456 789 - (+123) 666 888</span>
                                </li>
                                <li class="email">
                                    <span>roamingndovu@gmail.com</span>
                                </li>
                                <li class="time">
                                    <span>24/7 service</span>
                                </li>
                            </ul>
                            <div class="footer-social social">
                                <h3 class="footer-block-title">Follow us</h3>
                                <a href="#" class="fab fa-twitter"></a>
                                <a href="#" class="fab fa-facebook"></a>
                                <a href="#" class="fab fa-tiktok"></a>
                                <a href="#" class="fab fa-instagram"></a>
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                        <div class="footer-block">
                            <h3 class="footer-block-title">Quick menu</h3>
                            <ul class="footer-block-content">
                                <li><a href="#">TV & Video</a></li>
                                <li><a href="#">Home Audio & Theater</a></li>
                                <li><a href="#">Camera, Photo & Video</a></li>
                                <li><a href="#">Cell Phones & Accessories</a></li>
                                <li><a href="#">Headphones</a></li>
                                <li><a href="#">Video Games</a></li>
                                <li><a href="#">Bluetooth & Wireless Speakers</a></li>
                                <li><a href="#">Car Electronics</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xs-6 col-sm-6 col-md-2 col-lg-2">
                        <div class="footer-block">
                            <h3 class="footer-block-title">Customer Service</h3>
                            <ul class="footer-block-content">
                                <li><a href="#">My Account</a></li>
                                <li><a href="#">Track your Order</a></li>
                                <li><a href="#">Returns/Exchange</a></li>
                                <li><a href="#">FAQs</a></li>
                                <li><a href="#">Customer Service</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
                        <div class="footer-block">
                            <div class="footer-block-phone">
                                <h3 class="footer-block-title">Company</h3>
                                <p class="phone-desc">About</p>
                                <p class="phone-desc">Blog</p>
                                <p class="phone-desc">Home</p>
                                <p class="phone-desc">Get Card</p>
                                <p class="phone-desc">Support</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="f-bottom">
            <div class="container container-240">
                <div class="row flex lr">
                    <div class="col-xs-6 f-copyright"><span style="color: white;">© RoamingNdovu | All rights reserved.</span></div>
                    <div class="col-xs-6 f-payment hidden-xs"></div>
                </div>
            </div>
        </div>
    </footer>
    <!-- /footer -->
    </div>

    <script src="js/jquery.js"></script>
    <script src="js/bootstrap.js"></script>
    <script src="js/owl.carousel.min.js"></script>
    <script src="js/slick.min.js"></script>
    <script src="js/main.js"></script>
</body>

</html>