<?php
session_start(); // Uncomment this line to start the session

// Include database connection
require_once "../backend/config/database.php";

// Debug: Check if the session variable is set
// Remove this in production
// var_dump($_SESSION);

// Check if user is authenticated
$isAuthenticated = isset($_SESSION['user_id']);
$userId = $isAuthenticated ? $_SESSION['user_id'] : null;

// Pagination settings
$perPageOptions = [12, 24, 36, 48];
$perPage = isset($_GET['per_page']) && in_array((int)$_GET['per_page'], $perPageOptions) ? (int)$_GET['per_page'] : 12;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $perPage;

// Initialize database connection
$db = new DatabaseConfig();
$conn = $db->getConnection();// Fetch latest 6 categories for the category buttons
$categoriesStmt = $conn->query("SELECT * FROM categories ORDER BY created_at DESC LIMIT 6");
$categories = $categoriesStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch products for Flash Deals
$flashDealsStmt = $conn->prepare("
    SELECT p.*, c.name AS category_name 
    FROM products p 
    LEFT JOIN categories c ON p.category_id = c.category_id 
    WHERE p.is_active = 1 AND p.tags LIKE '%flashdeals%'
    LIMIT 10
");
$flashDealsStmt->execute();
$flashDeals = $flashDealsStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch products for Featured
$featuredStmt = $conn->prepare("
    SELECT p.*, c.name AS category_name 
    FROM products p 
    LEFT JOIN categories c ON p.category_id = c.category_id 
    WHERE p.is_active = 1 AND p.tags LIKE '%featured%'
    LIMIT :limit OFFSET :offset
");
$featuredStmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
$featuredStmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$featuredStmt->execute();
$featuredProducts = $featuredStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch products for Top Rated
$topRatedStmt = $conn->prepare("
    SELECT p.*, c.name AS category_name 
    FROM products p 
    LEFT JOIN categories c ON p.category_id = c.category_id 
    WHERE p.is_active = 1 AND p.tags LIKE '%toprated%'
    LIMIT :limit OFFSET :offset
");
$topRatedStmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
$topRatedStmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$topRatedStmt->execute();
$topRatedProducts = $topRatedStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch latest 6 products for What's New (2 rows, 3 per row)
$newStmt = $conn->prepare("
    SELECT p.*, c.name AS category_name 
    FROM products p 
    LEFT JOIN categories c ON p.category_id = c.category_id 
    WHERE p.is_active = 1 
    ORDER BY p.created_at DESC 
    LIMIT 6
");
$newStmt->execute();
$newProducts = $newStmt->fetchAll(PDO::FETCH_ASSOC);

// Fetch products for "You May Like"
$youMayLikeStmt = $conn->prepare("
    SELECT p.*, c.name AS category_name 
    FROM products p 
    LEFT JOIN categories c ON p.category_id = c.category_id 
    WHERE p.is_active = 1 
    ORDER BY RAND() 
    LIMIT 12
");
$youMayLikeStmt->execute();
$youMayLikeProducts = $youMayLikeStmt->fetchAll(PDO::FETCH_ASSOC);

// Merge all products and remove duplicates
$allProducts = array_merge($featuredProducts, $topRatedProducts, $newProducts, $youMayLikeProducts);
$uniqueProducts = [];
$productIds = [];
foreach ($allProducts as $product) {
    if (!in_array($product['product_id'], $productIds)) {
        $uniqueProducts[] = $product;
        $productIds[] = $product['product_id'];
    }
}
$allProducts = $uniqueProducts;

// Take the first 3 categories for the tab buttons
$tabCategories = array_slice($categories, 0, 3);

// Handle success/error messages from add_to_cart.php or add_to_wishlist.php
$message = $_GET['message'] ?? '';
$error = $_GET['error'] ?? '';

// Handle scroll_to parameter
$scrollTo = $_GET['scroll_to'] ?? '';

// Fetch cart items if user is authenticated
$cartItems = [];
$cartCount = 0;
$subtotal = 0;

if ($isAuthenticated) {
    try {
        $stmt = $conn->prepare("
            SELECT c.cart_id, c.product_id, c.quantity, p.name, p.price, p.primary_image
            FROM cart c
            JOIN products p ON c.product_id = p.product_id
            WHERE c.user_id = :user_id
        ");
        $stmt->execute(['user_id' => $userId]);
        $cartItems = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Calculate cart count and subtotal
        foreach ($cartItems as $item) {
            $cartCount += $item['quantity'];
            $subtotal += $item['price'] * $item['quantity'];
        }
    } catch (PDOException $e) {
        error_log("Failed to fetch cart items: " . $e->getMessage());
    }
}

// Fetch wishlist items if user is authenticated
$wishlistItems = [];
$wishlistCount = 0;

if ($isAuthenticated) {
    try {
        $stmt = $conn->prepare("
            SELECT w.wishlist_id, w.product_id, p.name, p.price, p.primary_image
            FROM wishlist w
            JOIN products p ON w.product_id = p.product_id
            WHERE w.user_id = :user_id
        ");
        $stmt->execute(['user_id' => $userId]);
        $wishlistItems = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Calculate wishlist count
        $wishlistCount = count($wishlistItems);
    } catch (PDOException $e) {
        error_log("Failed to fetch wishlist items: " . $e->getMessage());
    }
}
?>

<body>
    <!-- push menu-->
    <div class="pushmenu menu-home5">
        <div class="menu-push">
            <span class="close-left js-close"><i class="icon-close f-20"></i></span>
            <div class="clearfix"></div>
            <form role="search" method="get" id="searchform" class="searchform" action="/search">
               <div>
                  <label class="screen-reader-text" for="q"></label>
                  <input type="text" placeholder="Search for products" value="" name="q" id="q" autocomplete="off">
                  <input type="hidden" name="type" value="product">
                  <button type="submit" id="searchsubmit"><i class="ion-ios-search-strong"></i></button>
               </div>
            </form>
            <ul class="nav-home5 js-menubar">
                <li class="level1 active dropdown"><a href="#">Home</a>
                    <span class="icon-sub-menu"></span>
                </li>
                <li class="level1 active dropdown"><a href="#">Shop</a>
                    <span class="icon-sub-menu"></span>
                    <div class="menu-level1 js-open-menu">
                        <ul class="level1">
                            <li class="level2">
                                <a href="#">Shop Layout</a>
                            </li>
                            <li class="level2">
                                <a href="#">Categories</a>
                                <ul class="menu-level-2">
                                    <li class="level3"><a href="cat_fullwidth.html" title="">Categories Full Width</a></li>
                                    <li class="level3"><a href="cat_left_sidebar.html" title="">Categories Left Sidebar</a></li>
                                    <li class="level3"><a href="cat_right_sidebar.html" title="">Categories Right Sidebar</a></li>
                                </ul>
                            </li>
                            <li class="level2">
                                <a href="#">Single Product Type</a>
                                <ul class="menu-level-2">
                                    <li class="level3"><a href="bundle.html" title="">Bundle</a></li>
                                    <li class="level3"><a href="pin_product.html" title="">Pin Product</a></li>
                                    <li class="level3"><a href="360degree.html" title="">360 Degree</a></li>
                                    <li class="level3"><a href="feature_video.html" title="">Featued video</a></li>
                                    <li class="level3"><a href="simple.html">Simple</a></li>
                                    <li class="level3"><a href="variable.html">Variable</a></li>
                                    <li class="level3"><a href="affilate.html">External / Affiliate</a></li>
                                    <li class="level3"><a href="grouped.html">Grouped</a></li>
                                    <li class="level3"><a href="outofstock.html">Out of stock</a></li>
                                    <li class="level3"><a href="onsale.html">On sale</a></li>
                                </ul>
                            </li>
                            <li class="level2">
                                <a href="#">Pages</a>
                                <ul class="menu-level-2">
                                    <li class="level3"><a href="cart.html" title="">Cart</a></li>
                                    <li class="level3"><a href="wishlist.html" title="">My Wishlist</a></li>
                                    <li class="level3"><a href="checkout.html" title="">Checkout</a></li>
                                    <li class="level3"><a href="myaccount.html" title="">My Account</a></li>
                                    <li class="level3"><a href="track.html" title="">Track Your Order</a></li>
                                </ul>
                            </li>
                        </ul>
                        <div class="clearfix"></div>
                    </div>
                </li>
                <li class="level1 active dropdown"><a href="#">Menu</a></li>
                <li class="level1">
                    <a href="#">Pages</a>
                    <span class="icon-sub-menu"></span>
                    <ul class="menu-level1 js-open-menu">
                         <li class="level2"><a href="aboutus.html" title="About Us ">About Us </a></li>
                        <li class="level2"><a href="contactus.html" title="Contact">Contact</a></li>
                        <li class="level2"><a href="faq.html" title="FAQs">FAQs</a></li>
                        <li class="level2"><a href="404.html" title="404">404</a></li>
                        <li class="level2"><a href="commingsoon.html" title="Coming Soon">Coming Soon</a></li>
                    </ul>
                </li>
                <li class="level1">
                    <a href="#">Blog</a>
                    <span class="icon-sub-menu"></span>
                    <ul class="menu-level1 js-open-menu">
                        <li class="level2"><a href="../LandingPages/blog.html" title="Blog Standar">Blog</a></li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
    <!-- end push menu-->
    <div class="wrappage">
        <header id="header" class="header-v5">
           <div class="header-top-banner">
               <a href="#"><img src="img/banner-top.jpg" alt="" class="img-reponsive"></a>
           </div>
           <div class="topbar">
            <div class="container container-240">
                <div class="row flex">
                    <div class="col-md-6 col-sm-6 col-xs-4 flex-left">
                        <div class="topbar-left">
                            <div class="element element-store hidden-xs hidden-sm">
                                <a id="label1" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                <img src="img/icon-map.png" alt="">
                                  <span>Kenya</span>
                                </a>
                            </div>
                            <div class="element hidden-xs hidden-sm">
                                <a href="#"><img src="img/icon-track.png" alt=""><span>Track Your Order</span></a>
                            </div>
                            <div class="element element-account hidden-md hidden-lg">
                                <a href="<?php echo $isAuthenticated ? 'profile.php' : '../login.php'; ?>">My Account</a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-sm-6 col-xs-8 flex-right">
                        <div class="topbar-right">
                            <div class="element hidden-xs hidden-sm">
                                <a href="#">Help</a>
                            </div>
                            <div class="element hidden-xs hidden-sm">
                                <a href="#"><img src="img/icon-phone.png" alt=""><span>Save big with our discounts!</span></a>
                            </div>
                            <div class="element element-leaguage">
                                <a id="label2" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                    <img src="../Media/kenyanflag.jpg" alt="" width="20px" height="15px">
                                  <span>Kenya</span>
                                  <span class=" f-10 e-arrow"></span>
                                </a>
                                <ul class="dropdown-menu" aria-labelledby="label2">
                                    <li><a href="#">EN</a></li>
                                </ul>
                            </div>
                            <div class="element element-currency">
                                <a id="label3" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                  <span>KE</span>
                                  <span class=" f-10 e-arrow"></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-center">
            <div class="container container-240">
                <div class="row flex">
                    <div class="col-lg-2 col-md-2 col-sm-6 col-xs-6 v-center header-logo">
                        <a href="#"><img src="../Media/logo-bg-removed.png" alt="" class="img-reponsive" width="140px" height="100px"></a>
                    </div>
                    <div class="col-lg-7 col-md-7 v-center header-search hidden-xs hidden-sm">
                        <form method="get" class="searchform ajax-search" action="/search" role="search">
                            <input type="hidden" name="type" value="product">
                            <input type="text" onblur="if (this.value=='') this.value = this.defaultValue" onfocus="if (this.value==this.defaultValue) this.value = ''" name="q" class="form-control" placeholder="i’m shopping for...">
                            <ul class="list-product-search hidden-xs hidden-sm">
                                <!-- This will be dynamically populated by JavaScript -->
                            </ul>
                            <div class="search-panel">
                                <a class="dropdown-toggle" data-toggle="dropdown" href='#'>All categories <span class="fa fa-caret-down"></span></a>
                                <ul id="category" class="dropdown-menu dropdown-category">
                                    <li><a href="#">TV & Video</a></li>
                                    <li><a href="#">Home Audio & Theater</a></li>
                                    <li><a href="#">Camera, Photo & Video</a></li>
                                    <li><a href="#">Cell Phones & Accessories</a></li>
                                    <li><a href="#">Headphones</a></li>
                                    <li><a href="#">Car Electronics</a></li>
                                    <li><a href="#">Electronics Showcase</a></li>
                                </ul>
                            </div>
                            <span class="input-group-btn">
                                      <button class="button_search" type="button"><i class="ion-ios-search-strong"></i></button>
                            </span>
                        </form>
                        <div class="tags">
                            <span>Most searched :</span>
                            <a href="#">umbrella</a>
                            <a href="#">hair accessories </a>
                            <a href="#">diamond</a>
                            <a href="#"> painting slime</a>
                            <a href="#">sunglasses</a>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-3 col-sm-6 col-xs-6 v-center header-sub">
                        <div class="right-panel">
                            <div class="header-sub-element hidden-xs hidden-sm">
                            </div>
                            <div class="header-sub-element row">
                                <a class="hidden-xs hidden-sm" href="<?php echo $isAuthenticated ? 'profile.php' : '../login.php'; ?>"><img src="img/icon-user.png" alt=""></a>
                                <div class="wishlist">
                                    <a href="./wishlist.php" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">
                                        <img src="img/icon-heart.png" alt="">
                                    </a>
                                    <div class="dropdown-menu dropdown-cart">
                                        <?php if ($isAuthenticated && !empty($wishlistItems)): ?>
                                            <ul class="mini-products-list">
                                                <?php foreach ($wishlistItems as $item): ?>
                                                    <li class="item-cart">
                                                        <div class="product-img-wrap">
                                                            <a href="single_product.php?id=<?php echo htmlspecialchars($item['product_id']); ?>">
                                                                <img src="<?php echo "../".htmlspecialchars($item['primary_image']); ?>" alt="<?php echo htmlspecialchars($item['name']); ?>" class="img-reponsive">
                                                            </a>
                                                        </div>
                                                        <div class="product-details">
                                                            <div class="inner-left">
                                                                <div class="product-name">
                                                                    <a href="single_product.php?id=<?php echo htmlspecialchars($item['product_id']); ?>">
                                                                        <?php echo htmlspecialchars($item['name']); ?>
                                                                    </a>
                                                                </div>
                                                                <div class="product-price">
                                                                    $<?php echo number_format($item['price'], 2); ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <a href="remove_from_wishlist.php?wishlist_id=<?php echo htmlspecialchars($item['wishlist_id']); ?>" class="e-del"><i class="ion-ios-close-empty"></i></a>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                            <div class="bottom-cart">
                                                <div class="button-cart">
                                                    <a href="../shop/wishlist.php" class="cart-btn btn-viewcart">View Wishlist</a>
                                                </div>
                                            </div>
                                        <?php elseif ($isAuthenticated): ?>
                                            <div class="empty-cart">
                                                <p>Your wishlist is empty.</p>
                                            </div>
                                        <?php else: ?>
                                            <div class="empty-cart">
                                                <p>Please <a href="../login.php">log in</a> to view your wishlist.</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="cart">
                                    <a href="./cart.php" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false" id="label5">
                                        <img src="img/icon-cart.png" alt="">
                                        <span class="count cart-count"><?php echo $cartCount; ?></span>
                                    </a>
                                    <div class="dropdown-menu dropdown-cart">
                                        <?php if ($isAuthenticated && !empty($cartItems)): ?>
                                            <ul class="mini-products-list">
                                            <?php foreach (array_slice($cartItems, 0, 4) as $item): ?>
                                                    <li class="item-cart">
                                                        <div class="product-img-wrap">
                                                            <a href="single_product.php?id=<?php echo htmlspecialchars($item['product_id']); ?>">
                                                                <img src="<?php echo "../".htmlspecialchars($item['primary_image']); ?>" alt="<?php echo htmlspecialchars($item['name']); ?>" class="img-reponsive">
                                                            </a>
                                                        </div>
                                                        <div class="product-details">
                                                            <div class="inner-left">
                                                                <div class="product-name">
                                                                    <a href="single_product.php?id=<?php echo htmlspecialchars($item['product_id']); ?>">
                                                                        <?php echo htmlspecialchars($item['name']); ?>
                                                                    </a>
                                                                </div>
                                                                <div class="product-price">
                                                                    $<?php echo number_format($item['price'], 2); ?> <span>(x<?php echo $item['quantity']; ?>)</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <a href="remove_from_cart.php?cart_id=<?php echo htmlspecialchars($item['cart_id']); ?>" class="e-del"><i class="ion-ios-close-empty"></i></a>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                            <div class="bottom-cart">
                                                <div class="cart-price">
                                                    <span>Subtotal</span>
                                                    <span class="price-total">$<?php echo number_format($subtotal, 2); ?></span>
                                                </div>
                                                <div class="button-cart">
                                                    <a href="../shop/cart.php" class="cart-btn btn-viewcart">View Cart</a>
                                                    <a href="../shop/checkout.php" class="cart-btn e-checkout btn-gradient">Checkout</a>
                                                </div>
                                            </div>
                                        <?php elseif ($isAuthenticated): ?>
                                            <div class="empty-cart">
                                                <p>Your cart is empty.</p>
                                            </div>
                                        <?php else: ?>
                                            <div class="empty-cart">
                                                <p>Please <a href="../login.php">log in</a> to view your cart.</p>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <a href="#" class="hidden-md hidden-lg icon-pushmenu js-push-menu">
                                    <i class="fa fa-bars f-15"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="header-bottom hidden-xs hidden-sm">
            <div class="container container-240">
                <div class="row flex lr2">
                    <div class="col-lg-3 widget-verticalmenu">
                        <div class="navbar-vertical">
                            <button class="navbar-toggles navbar-drop js-vertical-menu"><span>All Departments</span></button>
                        </div>
                        <div class="vertical-wrapper">
                            <ul class="vertical-group">
                                <li class="vertical-item level1 mega-parent"><a href="#">New Arrivals</a></li>
                                <li class="vertical-item level1 mega-parent"><a href="#">Top 100 Best Seller <span class="h-ribbon e-red mg-l10">Hot</span></a></li>
                                <li class="vertical-item level1 vertical-drop"><a href="#">TV & Video</a>
                                    <div class="menu-level-1 dropdown-menu vertical-menu v2 tvbg pd2 style1">
                                        <ul class="level1">
                                            <li class="level2 col-md-5">
                                                <a href="#">TVs by Type</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">4K Ultra HD</a></li>
                                                    <li class="level3"><a href="#" title="">Smart TVs</a></li>
                                                    <li class="level3"><a href="#" title="">LED & LCD TVs & amplifiers</a></li>
                                                    <li class="level3"><a href="#" title="">OLED TVs</a></li>
                                                    <li class="level3"><a href="#" title="">QLED/Quantum Dot TVs</a></li>
                                                </ul>
                                                <a href="#">Blu-ray & DVD Players</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">4K Blu-ray Players</a></li>
                                                    <li class="level3"><a href="#" title="">Streaming Blu-ray Players</a></li>
                                                    <li class="level3"><a href="#" title="">3D Blu-ray Players</a></li>
                                                    <li class="level3"><a href="#" title="">Portable Blu-ray Players</a></li>
                                                    <li class="level3"><a href="#" title="">DVD Recorders</a></li>
                                                </ul>
                                            </li>
                                            <li class="level2 col-md-7">
                                                <a href="#">Home Audio</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">Home Theater Systems</a></li>
                                                    <li class="level3"><a href="#" title="">Soundbars</a></li>
                                                    <li class="level3"><a href="#" title="">Speakers</a></li>
                                                    <li class="level3"><a href="#" title="">Receivers & Amplifiers</a></li>
                                                    <li class="level3"><a href="#" title="">Premium Audio</a></li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="vertical-item level1 vertical-drop"><a href="#">Home Audi & Theater</a>
                                    <div class="menu-level-1 dropdown-menu vertical-menu v2 homebg pd2 style1">
                                        <ul class="level1">
                                            <li class="level2 col-md-4">
                                                <a href="#">Home theater</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">Sound bars</a></li>
                                                    <li class="level3"><a href="#" title="">Speakers</a></li>
                                                    <li class="level3"><a href="#" title="">Receivers & amplifiers</a></li>
                                                    <li class="level3"><a href="#" title="">Equalizers</a></li>
                                                    <li class="level3"><a href="#" title="">Phono preamps</a></li>
                                                </ul>
                                            </li>
                                            <li class="level2 col-md-4">
                                                <a href="#">Speakers</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">Bluetooth speakers</a></li>
                                                    <li class="level3"><a href="#" title="">Ceiling & in-wall speakers</a></li>
                                                    <li class="level3"><a href="#" title="">Digital music systems</a></li>
                                                    <li class="level3"><a href="#" title="">Outdoor</a></li>
                                                    <li class="level3"><a href="#" title="">Satellite speakers</a></li>
                                                </ul>
                                            </li>
                                            <li class="level2 col-md-4">
                                                <a href="#">Accessories</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">Receivers & amplifiers</a></li>
                                                    <li class="level3"><a href="#" title="">Cd & tape players</a></li>
                                                    <li class="level3"><a href="#" title="">Tuners</a></li>
                                                    <li class="level3"><a href="#" title="">Curntables</a></li>
                                                    <li class="level3"><a href="#" title="">Receivers & adapters</a></li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="vertical-item level1 vertical-drop"><a href="#">Camera, Photo & Video</a>
                                    <div class="menu-level-1 dropdown-menu vertical-menu">
                                        <ul class="vertical-menu1">
                                            <li><a href="#">Car Audio</a></li>
                                            <li><a href="#">Radar Detectors</a></li>
                                            <li><a href="#">Car Safety & Security</a></li>
                                            <li><a href="#">Car Video</a></li>
                                            <li><a href="#">Two-Way Radios</a></li>
                                            <li><a href="#">CB Radios & Scanners</a></li>
                                            <li><a href="#">In-Dash Mounting Kits</a></li>
                                            <li><a href="#">Installation Accessories.</a></li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="vertical-item level1 vertical-drop"><a href="#">Cell Phones & Accessories</a>
                                    <div class="menu-level-1 dropdown-menu vertical-menu v2 phonebg pd2 style1">
                                        <ul class="level1">
                                            <li class="level2 col-md-4">
                                                <a href="#">Cell Phones</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">Samsung Galaxy S8</a></li>
                                                    <li class="level3"><a href="#" title="">iPhone 7/7 Plus</a></li>
                                                    <li class="level3"><a href="#" title="">iPhone 6</a></li>
                                                    <li class="level3"><a href="#" title="">Samsung Galaxy S7</a></li>
                                                    <li class="level3"><a href="#" title="">Unlocked Phones</a></li>
                                                </ul>
                                                <a href="#">Cases</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">4Armbands</a></li>
                                                    <li class="level3"><a href="#" title="">Armbands</a></li>
                                                    <li class="level3"><a href="#" title="">Cases</a></li>
                                                    <li class="level3"><a href="#" title="">Flip Cases</a></li>
                                                    <li class="level3"><a href="#" title="">Holsters & Clips</a></li>
                                                </ul>
                                            </li>
                                            <li class="level2 col-md-8">
                                                <a href="#">Accessories</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">Batteries</a></li>
                                                    <li class="level3"><a href="#" title="">Bluetooth Headsets</a></li>
                                                    <li class="level3"><a href="#" title="">Bluetooth Speakers</a></li>
                                                    <li class="level3"><a href="#" title="">Car Accessories</a></li>
                                                    <li class="level3"><a href="#" title="">Chargers</a></li>
                                                </ul>
                                                <a href="#">Connected Devices</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">Tablets</a></li>
                                                    <li class="level3"><a href="#" title="">Mobile Hotspots</a></li>
                                                    <li class="level3"><a href="#" title="">Smart Watches</a></li>
                                                    <li class="level3"><a href="#" title="">Wearable Technology</a></li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="vertical-item level1 vertical-drop"><a href="#">Headphones</a>
                                    <div class="menu-level-1 dropdown-menu vertical-menu v2 headphonebg pd3 style1">
                                        <ul class="level1">
                                            <li class="level2 col-md-6">
                                                <a href="#">Headphones</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">In-Ear & Earbud</a></li>
                                                    <li class="level3"><a href="#" title="">On-Ear</a></li>
                                                    <li class="level3"><a href="#" title="">Over-Ear</a></li>
                                                    <li class="level3"><a href="#" title="">Wireless</a></li>
                                                    <li class="level3"><a href="#" title="">Sports & Fitness</a></li>
                                                </ul>
                                            </li>
                                            <li class="level2 col-md-6">
                                                <a href="#">Speaker System</a>
                                                <ul class="menu-level-2">
                                                    <li class="level3"><a href="#" title="">Complete Systems</a></li>
                                                    <li class="level3"><a href="#" title="">Sound Bars</a></li>
                                                    <li class="level3"><a href="#" title="">Surround Sound</a></li>
                                                    <li class="level3"><a href="#" title="">Receivers & Amplifiers</a></li>
                                                    <li class="level3"><a href="#" title="">Equalizers</a></li>
                                                </ul>
                                            </li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="vertical-item level1 vertical-drop"><a href="#">Car Electronics</a>
                                    <div class="menu-level-1 dropdown-menu vertical-menu">
                                        <ul class="vertical-menu1">
                                            <li><a href="#">Car Audio</a></li>
                                            <li><a href="#">Radar Detectors</a></li>
                                            <li><a href="#">Car Safety & Security</a></li>
                                            <li><a href="#">Car Video</a></li>
                                            <li><a href="#">Two-Way Radios</a></li>
                                            <li><a href="#">CB Radios & Scanners</a></li>
                                            <li><a href="#">In-Dash Mounting Kits</a></li>
                                            <li><a href="#">Installation Accessories.</a></li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="vertical-item level1 vertical-drop"><a href="#">Electronics Showcase</a>
                                    <div class="menu-level-1 dropdown-menu vertical-menu">
                                        <ul class="vertical-menu1">
                                            <li><a href="#">Car Audio</a></li>
                                            <li><a href="#">Radar Detectors</a></li>
                                            <li><a href="#">Car Safety & Security</a></li>
                                            <li><a href="#">Car Video</a></li>
                                            <li><a href="#">Two-Way Radios</a></li>
                                            <li><a href="#">CB Radios & Scanners</a></li>
                                            <li><a href="#">In-Dash Mounting Kits</a></li>
                                            <li><a href="#">Installation Accessories.</a></li>
                                        </ul>
                                    </div>
                                </li>
                                <li class="vertical-item level1 vertical-drop mega-parent"><a href="#">All categories</a>
                                    <div class="menu-level-1 dropdown-menu vertical-menu v2 pd">
                                        <div class="row">
                                            <div class="col-md-4 text-center cate-item">
                                                <a href="#"><img src="img/megamenu/cate1.jpg" alt="" class="img-reponsive"></a>
                                                <h3><a href="#">Mirrorless Cameras</a></h3>
                                            </div>
                                            <div class="col-md-4 text-center cate-item">
                                                <a href="#"><img src="img/megamenu/cate2.jpg" alt="" class="img-reponsive"></a>
                                                <h3><a href="#">Lenses</a></h3>
                                            </div>
                                            <div class="col-md-4 text-center cate-item">
                                                <a href="#"><img src="img/megamenu/cate3.jpg" alt="" class="img-reponsive"></a>
                                                <h3><a href="#">Photography Drones</a></h3>
                                            </div>
                                            <div class="col-md-4 text-center cate-item">
                                                <a href="#"><img src="img/megamenu/cate4.jpg" alt="" class="img-reponsive"></a>
                                                <h3><a href="#">Sports & Action Cameras</a></h3>
                                            </div>
                                            <div class="col-md-4 text-center cate-item">
                                                <a href="#"><img src="img/megamenu/cate5.jpg" alt="" class="img-reponsive"></a>
                                                <h3><a href="#">Optics</a></h3>
                                            </div>
                                            <div class="col-md-4 text-center cate-item">
                                                <a href="#"><img src="img/megamenu/cate6.jpg" alt="" class="img-reponsive"></a>
                                                <h3><a href="#">Accessories</a></h3>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="col-lg-9 widget-left">
                        <div class="flex lr e-border">
                            <nav class="main-menu flex align-center">
                                <button type="button" class="icon-mobile e-icon-menu icon-pushmenu js-push-menu">
                                    <span class="navbar-toggler-bar"></span>
                                    <span class="navbar-toggler-bar"></span>
                                    <span class="navbar-toggler-bar"></span>
                                </button>
                                <div class="collapse navbar-collapse" id="myNavbar">
                                    <ul class="nav navbar-nav js-menubar">
                                        <li class="level1 active dropdown">
                                            <a href="#">Pages<span class="h-ribbon h-pos e-skyblue">new</span></a>
                                            <span class="plus js-plus-icon"></span>
                                            <ul class="dropdown-menu menu-level-1">
                                                <li class="level2"><a href="aboutus.html" title="About Us ">About Us </a></li>
                                                <li class="level2"><a href="contactus.html" title="Contact">Contact</a></li>
                                                <li class="level2"><a href="faq.html" title="FAQs">FAQs</a></li>
                                                <li class="level2"><a href="404.html" title="404">404</a></li>
                                                <li class="level2"><a href="commingsoon.html" title="Coming Soon">Coming Soon</a></li>
                                            </ul>
                                        </li>
                                        <li class="level1 active dropdown">
                                            <a href="#">Blog</a>
                                            <ul class="dropdown-menu menu-level-1">
                                                <li class="level2"><a href="../LandingPages/blog.html" title="Blog Standar">Blog</a></li>
                                            </ul>
                                        </li>
                                    </ul>
                                </div>
                            </nav>
                            <div class="header-bottom-right hidden-xs hidden-sm">
                                <img src="img/icon-ship.png" alt="" class="img-reponsive">
                                <span>Free Shipping on Orders $100</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </header>
    <div class="container container-240">
    <?php if ($message): ?>
        <div class="alert alert-success" style="position: relative; padding: 12px 35px 12px 15px; margin-bottom: 15px; background-color: #dff0d8; border: 1px solid #d6e9c6; border-radius: 4px; color: #3c763d;">
            <?php echo htmlspecialchars($message); ?>
            <button type="button" style="position: absolute; top: 0; right: 0; padding: 10px 15px; background: none; border: none; font-size: 18px; font-weight: bold; cursor: pointer; color: #3c763d;" onclick="this.parentElement.style.display='none';">×</button>
        </div>
    <?php endif; ?>
    
    <?php if ($error): ?>
        <div class="alert alert-danger" style="position: relative; padding: 12px 35px 12px 15px; margin-bottom: 15px; background-color: #f2dede; border: 1px solid #ebccd1; border-radius: 4px; color: #a94442;">
            <?php echo htmlspecialchars($error); ?>
            <button type="button" style="position: absolute; top: 0; right: 0; padding: 10px 15px; background: none; border: none; font-size: 18px; font-weight: bold; cursor: pointer; color: #a94442;" onclick="this.parentElement.style.display='none';">×</button>
        </div>
    <?php endif; ?>
</div>

<style>
    .list-product-search {
    position: absolute;
    top: 100%;
    left: 0;
    right: 0;
    background: #fff;
    border: 1px solid #ddd;
    border-radius: 4px;
    box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
    z-index: 1000;
    display: none;
    max-height: 300px;
    overflow-y: auto;
}

.list-product-search li {
    padding: 10px;
    border-bottom: 1px solid #eee;
}

.list-product-search li:last-child {
    border-bottom: none;
}

.list-product-search a {
    display: flex;
    align-items: center;
    text-decoration: none;
    color: #333;
}

.list-product-search .product-img img {
    width: 50px;
    height: 50px;
    margin-right: 10px;
}

.list-product-search .product-title {
    font-size: 14px;
    margin: 0;
}

.list-product-search a:hover {
    background-color: #f5f5f5;
}
</style>