<?php 
session_start(); // Uncomment this line to start the session
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Roaming Ndovuu | Store</title>
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="shortcut icon" href="../Media/logo.png" type="image/png">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/owl.theme.default.min.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .header-top-banner {
            background-color: green;
        }
        .slide-btn .e-red-gradient:hover {
            background-color: #072f10be;
            box-shadow: none;
        }
    </style>
</head>
<body>
    <?php include "./header.php"; ?>

    

<!-- Scroll to Product Script -->
        <?php if ($scrollTo): ?>
            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    const productId = <?php echo json_encode($scrollTo); ?>;
                    const element = document.querySelector(`[data-product-id="${productId}"]`);
                    if (element) {
                        element.scrollIntoView({ 
                            behavior: 'smooth', 
                            block: 'center',
                            inline: 'nearest'
                        });
                        
                        // Clean URL after scroll
                        const url = new URL(window.location);
                        url.searchParams.delete('scroll_to');
                        window.history.replaceState({}, '', url);
                    }
                });
            </script>
        <?php endif; ?>

    <div class="flash-deals">
        <div class="container container-240">
            <div class="title-icon t-column">
                <div class="t-inside">
                    <img src="img/flash-deals.png" alt="">
                </div>
                <h1>Flash Deals</h1>
            </div>
            <!-- Flash Deals Section -->
            <div class="section flash-deals">
                <div class="owl-carousel owl-theme owl-cate js-owl-cate2">
                    <?php foreach ($flashDeals as $product): ?>
                        <div class="product-countd pd-bd product-inner" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                            <div class="product-item-countd" >
                                <div class="product-head product-img">
                                    <a href="single_product.php?id=<?php echo htmlspecialchars($product['product_id']); ?>">
                                        <img src="<?php echo "../".htmlspecialchars($product['primary_image']); ?>" alt="<?php echo htmlspecialchars($product['description']); ?>">
                                    </a>
                                    <div class="ribbon-price v3 red"><span>- 30% </span></div>
                                </div>
                                <div class="product-info">
                                    <p class="product-cate text-center"><?php echo htmlspecialchars($product['category_name']); ?></p>
                                    <div class="product-price thin-price v3">
                                        <span class="red">$<?php echo number_format($product['price'], 2); ?></span>
                                        <span class="old">$<?php echo number_format($product['price'] * 1.3, 2); ?></span>
                                    </div>
                                    <h3 class="product-title text-center v2">
                                        <a href="single_product.php?id=<?php echo htmlspecialchars($product['product_id']); ?>">
                                            <?php echo htmlspecialchars($product['description']); ?>
                                        </a>
                                    </h3>
                                    <div class="deal-progress">
                                        <div class="deal-stock">
                                            <span class="stock-sold">19% already claimed</span>
                                            <span class="stock-available">Available: <strong><?php echo htmlspecialchars($product['stock']); ?></strong></span>
                                        </div>
                                        <div class="progress">
                                            <span class="progress-bar" style="width:27.5956%"></span>
                                        </div>
                                    </div>
                                    <div class="time-cound">
                                        <p class="text-center">Deal ends in :</p>
                                        <div class="countdown countdown-time" data-countdown="countdown" data-date="08-31-2018-00-00-00"></div>
                                    </div>
                                    <div class="product-bottom-group">
                                        <a href="<?php echo $isAuthenticated ? 'add_to_cart.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon cart-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                            <span class="icon-bg icon-cart">cart</span>
                                        </a>
                                        <a href="<?php echo $isAuthenticated ? 'add_to_wishlist.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon wishlist-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                            <span class="icon-bg icon-wishlist">wishlist</span>
                                        </a>                                    
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- JavaScript for Client-Side Validation -->
            <script>
                document.querySelectorAll('.cart-btn, .wishlist-btn').forEach(link => {
                    link.addEventListener('click', function(e) {
                        const isAuthenticated = <?php echo json_encode($isAuthenticated); ?>;
                        if (!isAuthenticated) {
                            e.preventDefault();
                            alert('Please log in to add items to your cart or wishlist.');
                            window.location.href = '../login.php';
                        } else {
                            console.log('Action:', this.classList.contains('cart-btn') ? 'Add to Cart' : 'Add to Wishlist');
                            console.log('Product ID:', this.getAttribute('data-product-id'));
                        }
                    });
                });
            </script>
            <!-- CSS for Styling -->
            <style>
                /* General Section Styling */
                .section h2 {
                    text-align: center;
                    margin-bottom: 20px;
                }

                /* Owl Carousel Item Styling */
                .js-owl-cate2 .product-countd {
                    text-align: center;
                    padding: 10px;
                }

                /* Image Container Styling */
                .product-head.product-img {
                    position: relative;
                    width: 400px;
                    height: 400px;
                    margin: 0 auto;
                    overflow: hidden;
                }

                /* Image Styling */
                .product-head.product-img img {
                    width: 100%;
                    height: 100%;
                    object-fit: cover;
                    object-position: center;
                    display: block;
                }

                /* Ribbon Styling */
                .ribbon-price.v3.red {
                    position: absolute;
                    top: 10px;
                    right: 10px;
                    background-color: red;
                    color: white;
                    padding: 5px 10px;
                    font-size: 14px;
                }

                /* Product Info Styling */
                .product-info {
                    padding: 10px 0;
                }

                .product-cate {
                    font-size: 14px;
                    color: #666;
                    margin-bottom: 5px;
                }

                .product-price.thin-price.v3 {
                    margin: 10px 0;
                }

                .product-price .red {
                    color: red;
                    font-size: 18px;
                    font-weight: bold;
                }

                .product-price .old {
                    color: #999;
                    text-decoration: line-through;
                    font-size: 14px;
                    margin-left: 10px;
                }

                .product-title.v2 a {
                    font-size: 16px;
                    color: #333;
                    text-decoration: none;
                }

                .product-title.v2 a:hover {
                    color: #007bff;
                }

                /* Deal Progress Styling */
                .deal-progress {
                    margin: 10px 0;
                }

                .deal-stock {
                    display: flex;
                    justify-content: space-between;
                    font-size: 12px;
                    color: #666;
                }

                .progress {
                    height: 5px;
                    background-color: #f0f0f0;
                    border-radius: 5px;
                    margin-top: 5px;
                }

                .progress-bar {
                    height: 100%;
                    background-color: #28a745;
                    border-radius: 5px;
                }

                /* Countdown Styling */
                .time-cound {
                    margin-top: 10px;
                }

                .time-cound p {
                    font-size: 14px;
                    color: #666;
                }

                .countdown-time {
                    font-size: 16px;
                    font-weight: bold;
                    color: #333;
                }

                /* Responsive Adjustments */
                @media (max-width: 768px) {
                    .product-head.product-img {
                        width: 250px;
                        height: 400px;
                    }
                }

                @media (max-width: 576px) {
                    .product-head.product-img {
                        width: 300px;
                        height: 100px;
                    }
                }
            </style>

            <!-- JavaScript for Owl Carousel Initialization -->
            <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
            <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">

            <script>
                $(document).ready(function(){
                    $('.js-owl-cate2').owlCarousel({
                        items: 3,
                        loop: true,
                        margin: 20,
                        nav: true,
                        dots: false,
                        responsive: {
                            0: { items: 1 },
                            600: { items: 2 },
                            1000: { items: 3 }
                        }
                    });
                });
            </script>
        </div>
    </div>

    <div class="product-tab bg-gradient bg-insinde">
        <div class="container container-240">
            <ul class="product-tab-sw">
                <?php foreach ($tabCategories as $index => $category): ?>
                    <li class="<?php echo $index === 0 ? 'active' : ''; ?>">
                        <a data-toggle="tab" href="#category-<?php echo $category['category_id']; ?>">
                            <?php echo htmlspecialchars($category['name']); ?>
                        </a>
                    </li>
                <?php endforeach; ?>                    
            </ul>

            <!-- Product Tabs Content -->
            <div class="tab-content">
                <?php foreach ($tabCategories as $index => $category): ?>
                    <div id="category-<?php echo $category['category_id']; ?>" class="tab-pane fade <?php echo $index === 0 ? 'in active' : ''; ?>">
                        <div class="product-tab-pd js-multiple-row2">
                            <?php foreach ($allProducts as $product): ?>  
                                <div class="product-item" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">

                                    <div class="pd-bd product-inner">
                                        <div class="product-img">
                                            <a href="single_product.php?id=<?php echo htmlspecialchars($product['product_id']);?>">
                                                <img src="<?php echo "../".htmlspecialchars($product['primary_image']); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>" class="img-reponsive"></a>
                                        </div>
                                        <div class="product-info">
                                            <div class="color-group">
                                            </div>
                                            <div class="element-list element-list-left">
                                                <ul class="desc-list">
                                                    <li><?php echo htmlspecialchars($product['description']); ?></li>
                                                </ul>
                                            </div>
                                            <div class="element-list element-list-middle">
                                                <div class="product-rating bd-rating">
                                                    <span class="star star-5"></span>
                                                    <span class="star star-4"></span>
                                                    <span class="star star-3"></span>
                                                    <span class="star star-2"></span>
                                                    <span class="star star-1"></span>
                                                    <div class="number-rating"><?php echo htmlspecialchars($product['review_count'] ?? 0); ?></div>
                                                </div>
                                                <p class="product-cate"><?php echo htmlspecialchars($product['category_name']); ?></p>
                                                <h3 class="product-title"><a href="#"><?php echo htmlspecialchars($product['name']); ?></a></h3>
                                                <div class="product-bottom">
                                                    <div class="product-price"><span>$<?php echo number_format($product['price'], 2); ?></span></div>
                                                    <a href="#" class="btn-icon btn-view">
                                                        <span class="icon-bg icon-view"></span>
                                                    </a>
                                                </div>
                                                <div class="product-bottom-group">
                                                    <a href="<?php echo $isAuthenticated ? 'add_to_cart.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon cart-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                                        <span class="icon-bg icon-cart">CART</span>
                                                    </a>
                                                    <a href="<?php echo $isAuthenticated ? 'add_to_wishlist.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon wishlist-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                                        <span class="icon-bg icon-wishlist">WISHLIST</span>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="product-button-group">
                                                <a href="<?php echo $isAuthenticated ? 'add_to_cart.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon cart-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                                    <span class="icon-bg icon-cart">CART</span>
                                                </a>
                                                <a href="<?php echo $isAuthenticated ? 'add_to_wishlist.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon wishlist-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                                    <span class="icon-bg icon-wishlist">WISHLIST</span>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>

            <!-- CSS for Styling -->
            <style>
                /* Product Tabs Content */
                .tab-content {
                    padding: 20px 0;
                }

                /* Product Items */
                .product-tab-pd {
                    padding: 10px 0;
                }

                .product-item {
                    width: 100%;
                    padding: 10px;
                }

                .product-inner {
                    border: 1px solid #eee;
                    padding: 15px;
                    background: #fff;
                    transition: box-shadow 0.3s ease;
                }

                .product-inner:hover {
                    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
                }

                /* Image Styling */
                .product-img {
                    width: 100px;
                    height: 200px;
                    margin: 0 auto;
                    overflow: hidden;
                }

                .product-img img {
                    width: 100%;
                    height: 100%;
                    object-fit: cover;
                    object-position: center;
                    display: block;
                }

                /* Product Info */
                .product-info {
                    padding: 15px 0;
                    text-align: center;
                }

                .element-list-left {
                    display: none;
                }

                .desc-list {
                    list-style: none;
                    padding: 0;
                    font-size: 12px;
                    color: #666;
                    margin: 0;
                }

                .desc-list li {
                    margin-bottom: 5px;
                }

                .element-list-middle {
                    text-align: center;
                }

                .product-rating {
                    margin-bottom: 10px;
                }

                .star {
                    display: inline-block;
                    width: 16px;
                    height: 16px;
                    background: url('img/star.png') no-repeat;
                }

                .star.star-5,
                .star.star-4,
                .star.star-3,
                .star.star-2,
                .star.star-1 {
                    background-position: 0 0;
                }

                .number-rating {
                    display: inline-block;
                    font-size: 12px;
                    color: #666;
                    margin-left: 5px;
                }

                .product-cate {
                    font-size: 14px;
                    color: #999;
                    margin-bottom: 5px;
                }

                .product-title a {
                    font-size: 16px;
                    color: #333;
                    text-decoration: none;
                }

                .product-title a:hover {
                    color: #007bff;
                }

                .product-bottom {
                    display: flex;
                    justify-content: space-between;
                    align-items: center;
                    margin-top: 10px;
                }

                .product-price span {
                    font-size: 18px;
                    font-weight: bold;
                    color: #e74c3c;
                }

                .btn-icon {
                    display: inline-block;
                    width: 30px;
                    height: 30px;
                    background: #f5f5f5;
                    border-radius: 50%;
                    text-align: center;
                    line-height: 30px;
                }

                .icon-bg {
                    display: inline-block;
                    width: 16px;
                    height: 16px;
                    background: url('img/icons.png') no-repeat;
                }

                .icon-view { background-position: 0 0; }
                .icon-cart { background-position: -16px 0; }
                .icon-wishlist { background-position: -32px 0; }
                .icon-compare { background-position: -48px 0; }

                .product-bottom-group,
                .product-button-group {
                    display: flex;
                    justify-content: center;
                    gap: 10px;
                    margin-top: 10px;
                }

                /* Slick Carousel Adjustments */
                .js-multiple-row2 .product-item {
                    width: 100%;
                }

                /* Responsive Design */
                @media (max-width: 768px) {
                    .product-img {
                        width: 80px;
                        height: 160px;
                    }

                    .product-title a {
                        font-size: 14px;
                    }

                    .product-price span {
                        font-size: 16px;
                    }
                }

                @media (max-width: 576px) {
                    .product-img {
                        width: 60px;
                        height: 120px;
                    }

                    .product-title a {
                        font-size: 12px;
                    }

                    .product-price span {
                        font-size: 14px;
                    }
                }
            </style>
        </div>
    </div>

    <!-- You May Like Section -->
    <div class="more-product bg-gradient bg-insinde">
        <div class="container container-240">
            <div class="h-heading">
                <div class="title-icon t-inline">
                    <img src="img/iconbs.png" alt="">
                    <h1>You may like</h1>
                </div>
                <a href="#" class="btn-morepd">
                    <span><i class="icon-refresh"></i></span>Refresh for more
                </a>
            </div>
            <div class="multiple-row js-multiple-row">
                <?php foreach ($youMayLikeProducts as $product): ?>
                    <div class="product-item" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                        <div class="pd-bd product-inner v2">
                            <div class="flex align-center">
                                <div class="product-img">
                                    <a href="single_product.php?id=<?php echo htmlspecialchars($product['product_id']); ?>">
                                        <img src="<?php echo "../".htmlspecialchars($product['primary_image']); ?>" alt="" class="img-reponsive"></a>
                                </div>
                                <div class="product-info">
                                    <div class="element-list element-list-middle">
                                        <p class="product-cate"><?php echo htmlspecialchars($product['category_name']); ?></p>
                                        <h3 class="product-title"><a href="#"><?php echo htmlspecialchars($product['description']); ?></a></h3>
                                        <div class="product-bottom v2">
                                            <div class="product-price"><span>$<?php echo number_format($product['price'], 2); ?></span></div>
                                            <div class="product-bottom-element flex">
                                                <a href="#" class="btn-icon btn-view"><span class="icon-bg icon-view"></span></a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="product-button-group hidden-xs hidden-sm">
                                        <a href="<?php echo $isAuthenticated ? 'add_to_cart.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon cart-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                            <span class="icon-bg icon-cart">CART</span>
                                        </a>
                                        <a href="<?php echo $isAuthenticated ? 'add_to_wishlist.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon wishlist-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                            <span class="icon-bg icon-wishlist">WISHLIST</span>
                                        </a>
                                    </div>
                                </div>
                            </div>
                            <div class="product-button-group hidden-md hidden-lg">
                                <a href="<?php echo $isAuthenticated ? 'add_to_cart.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon cart-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                    <span class="icon-bg icon-cart">CART</span>
                                </a>
                                <a href="<?php echo $isAuthenticated ? 'add_to_wishlist.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon wishlist-btn" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                    <span class="icon-bg icon-wishlist">WISHLIST</span>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

  <?php include 'footer.php'; ?>