
<?php 
session_start ();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Roaming Ndovu | Profile</title>
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="shortcut icon" href="../Media/logo.png" type="image/png">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/owl.theme.default.min.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .header-top-banner {
            background-color: green;
        }
        .profile-section {
            background: #fff;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .profile-section h2 {
            margin-bottom: 20px;
        }
        .profile-section .form-group {
            margin-bottom: 15px;
        }
        .profile-section label {
            font-weight: bold;
        }
        .profile-section input {
            width: 100%;
            padding: 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }
        .profile-section .btn-update {
            background-color: #28a745;
            color: #fff;
            padding: 10px 20px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        .profile-section .btn-update:hover {
            background-color: #218838;
        }
        .alert {
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 4px;
            display: none; /* Hidden by default for AJAX */
        }
        .alert-success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
    </style>
</head>

<body>
    <?php include "./header.php"; ?>

    <!-- Content -->
    <div class="container container-240">
        <div class="profile">
            <ul class="breadcrumb v3">
                <li><a href="./">Home</a></li>
                <li class="active">Profile</li>
            </ul>

            <?php
            // Start the session
            // session_start();

            // Include database connection
            require_once "../backend/config/database.php";

            // Check if user is authenticated
            if (!isset($_SESSION['user_id'])) {
                header("Location: ../login.php?error=Please log in to view your profile.");
                exit;
            }

            $userId = $_SESSION['user_id'];
            $db = new DatabaseConfig();
            $conn = $db->getConnection();

            // Fetch user details
            try {
                $stmt = $conn->prepare("SELECT first_name, last_name, email, phone FROM users WHERE user_id = :user_id");
                $stmt->execute(['user_id' => $userId]);
                $user = $stmt->fetch(PDO::FETCH_ASSOC);

                if (!$user) {
                    echo '<div class="alert alert-danger">User not found.</div>';
                    exit;
                }
            } catch (PDOException $e) {
                error_log("Failed to fetch user details: " . $e->getMessage());
                echo '<div class="alert alert-danger">An error occurred while fetching your profile. Please try again.</div>';
                exit;
            }
            ?>

            <div class="row">
                <div class="col-md-8 col-sm-12 col-xs-12">
                    <!-- Profile Update Section -->
                    <div class="profile-section">
                        <div class="cmt-title text-center abs">
                            <h1 class="page-title v2">My Profile</h1>
                        </div>

                        <div id="profile-message" class="alert"></div>

                        <form id="profile-form">
                            <div class="form-group">
                                <label for="first_name">First Name</label>
                                <input type="text" name="first_name" id="first_name" value="<?php echo htmlspecialchars($user['first_name']); ?>" required>
                            </div>
                            <div class="form-group">
                                <label for="last_name">Last Name</label>
                                <input type="text" name="last_name" id="last_name" value="<?php echo htmlspecialchars($user['last_name']); ?>" required>
                            </div>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" name="email" id="email" value="<?php echo htmlspecialchars($user['email']); ?>" required>
                            </div>
                            <div class="form-group">
                                <label for="phone">Phone Number</label>
                                <input type="text" name="phone" id="phone" value="<?php echo htmlspecialchars($user['phone'] ?? ''); ?>">
                            </div>
                            <button type="submit" class="btn btn-update">Update Profile</button>
                        </form>
                    </div>

                    <!-- Password Update Section -->
                    <div class="profile-section">
                        <div class="cmt-title text-center abs">
                            <h1 class="page-title v2">Change Password</h1>
                        </div>

                        <div id="password-message" class="alert"></div>

                        <form id="password-form">
                            <div class="form-group">
                                <label for="current_password">Current Password</label>
                                <input type="password" name="current_password" id="current_password" required>
                            </div>
                            <div class="form-group">
                                <label for="new_password">New Password</label>
                                <input type="password" name="new_password" id="new_password" required>
                            </div>
                            <div class="form-group">
                                <label for="confirm_password">Confirm New Password</label>
                                <input type="password" name="confirm_password" id="confirm_password" required>
                            </div>
                            <button type="submit" class="btn btn-update">Update Password</button>
                        </form>
                    </div>
                </div>
                <div class="col-md-4 col-sm-12 col-xs-12">
                    <div class="profile-section">
                        <div class="cmt-title text-center abs">
                            <h1 class="page-title v3">Account Options</h1>
                        </div>
                        <div class="account-options">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item">
                                    <a href="wishlist.php" class="account-link">View Wishlist</a>
                                </li>
                                <li class="list-group-item">
                                    <a href="cart.php" class="account-link">View Cart</a>
                                </li>
                                <li class="list-group-item">
                                    <a href="checkout.php" class="account-link">Proceed to Checkout</a>
                                </li>
                                <li class="list-group-item">
                                    <a href="../backend/users/logout.php" class="account-link logout-link">Logout</a>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <style>
                    /* Existing styles for .profile-section */
                    .profile-section {
                        background: #fff;
                        padding: 20px;
                        border: 1px solid #ddd;
                        border-radius: 5px;
                        margin-bottom: 20px;
                    }

                    /* Style the title */
                    .cmt-title {
                        position: relative;
                        margin-bottom: 20px;
                    }

                    .page-title.v3 {
                        font-size: 24px;
                        font-weight: 600;
                        color: #333;
                    }

                    /* Style the account options list */
                    .account-options .list-group {
                        border: none;
                    }

                    .account-options .list-group-item {
                        border: none;
                        padding: 10px 0;
                        background: transparent;
                        text-align: center; /* Center the links */
                    }

                    /* Style the links */
                    .account-options .account-link {
                        display: block;
                        color: #1a3c34; /* Match the login button color from login.php */
                        font-size: 16px;
                        font-weight: 500;
                        text-decoration: none;
                        padding: 8px 15px;
                        border-radius: 4px;
                        transition: background-color 0.3s, color 0.3s;
                    }

                    .account-options .account-link:hover {
                        background-color: #f0f4f8; /* Light background on hover, matching login.php input background */
                        color: #14532d; /* Darker shade on hover, matching login button hover */
                    }

                    /* Style the logout link differently for emphasis */
                    .account-options .logout-link {
                        color: #721c24; /* Red color to indicate a destructive action */
                    }

                    .account-options .logout-link:hover {
                        background-color: #f8d7da; /* Light red background on hover, matching alert-danger */
                        color: #721c24;
                    }

                    /* Ensure the list items have proper spacing */
                    .account-options .list-group-item + .list-group-item {
                        margin-top: 5px;
                    }
                </style>
            </div>
        </div>
    </div>

    <?php include "./footer.php"; ?>

   