<?php
session_start();

// Include database connection
require_once '../backend/config/database.php';

// Check if user is authenticated
if (!isset($_SESSION['user_id'])) {
    header('Location: ../login.php');
    exit;
}

$userId = $_SESSION['user_id'];

// Validate cart_id
if (!isset($_GET['cart_id']) || !is_numeric($_GET['cart_id'])) {
    header('Location: index.php?error=Invalid cart ID');
    exit;
}

$cartId = (int)$_GET['cart_id'];

// Remove from cart
$db = new DatabaseConfig();
$conn = $db->getConnection();

try {
    $stmt = $conn->prepare("DELETE FROM cart WHERE cart_id = :cart_id AND user_id = :user_id");
    $stmt->execute([
        'cart_id' => $cartId,
        'user_id' => $userId
    ]);

    // Redirect back to the previous page
    $referer = $_SERVER['HTTP_REFERER'] ?? 'index.php';
    header("Location: $referer?message=Item removed from cart successfully");
    exit;
} catch (PDOException $e) {
    error_log("Failed to remove from cart: " . $e->getMessage());
    $referer = $_SERVER['HTTP_REFERER'] ?? 'index.php';
    header("Location: $referer?error=Failed to remove item from cart");
    exit;
}
?>