<?php

session_start();

require_once "../backend/config/database.php";

// Check if product ID is set and valid
$product_id = isset($_GET['id']) && is_numeric($_GET['id']) ? (int)$_GET['id'] : 0;

// If product ID is not set or invalid, redirect to index.php
if ($product_id === 0) {
    header("Location: index.php");
    exit(); // Stop script execution after redirect
}

$db = new DatabaseConfig();
$conn = $db->getConnection();

// Fetch product details
try {
    $productStmt = $conn->prepare("
        SELECT p.*, c.name AS category_name
        FROM products p
        LEFT JOIN categories c ON p.category_id = c.category_id
        WHERE p.product_id = :product_id AND p.is_active = 1
    ");
    $productStmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
    $productStmt->execute();
    $product = $productStmt->fetch(PDO::FETCH_ASSOC);

    if (!$product) {
        die("Product not found.");
    }
} catch (PDOException $e) {
    die("Error fetching product: " . $e->getMessage());
}
// Set the primary image with a fallback
"..".$primaryImage = !empty($product['primary_image']) ? htmlspecialchars($product['primary_image']) : 'img/default-product.jpg';

// Fetch related products (same category, excluding the current product)
try {
    $relatedStmt = $conn->prepare("
        SELECT p.*, c.name AS category_name 
        FROM products p 
        LEFT JOIN categories c ON p.category_id = c.category_id 
        WHERE p.category_id = :category_id AND p.product_id != :product_id AND p.is_active = 1 
        LIMIT 10
    ");
    $relatedStmt->bindParam(':category_id', $product['category_id'], PDO::PARAM_INT);
    $relatedStmt->bindParam(':product_id', $product_id, PDO::PARAM_INT);
    $relatedStmt->execute();
    $relatedProducts = $relatedStmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $relatedProducts = [];
}

// Fetch featured products (newest products)
try {
    $featuredStmt = $conn->query("SELECT p.*, c.name AS category_name FROM products p LEFT JOIN categories c ON p.category_id = c.category_id WHERE p.is_active = 1 ORDER BY p.created_at DESC LIMIT 3");
    $featuredProducts = $featuredStmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $featuredProducts = [];
}

// Fetch top-rated products (using average_rating)
try {
    $topRatedStmt = $conn->query("SELECT p.*, c.name AS category_name FROM products p LEFT JOIN categories c ON p.category_id = c.category_id WHERE p.is_active = 1 ORDER BY p.average_rating DESC LIMIT 3");
    $topRatedProducts = $topRatedStmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $topRatedProducts = [];
}

// Fetch top-selling products (using sales_count)
try {
    $topSellingStmt = $conn->query("SELECT p.*, c.name AS category_name FROM products p LEFT JOIN categories c ON p.category_id = c.category_id WHERE p.is_active = 1 ORDER BY p.sales_count DESC LIMIT 3");
    $topSellingProducts = $topSellingStmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    $topSellingProducts = [];
}
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Roaming Ndovu | Store</title>
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="shortcut icon" href="../Media/logo.png" type="image/png">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/owl.theme.default.min.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .header-top-banner{
            background-color: green;
        }
    </style>
</head>

<body>


    <?php include "./header.php"; ?>
    <div class="container container-240">
        <div class="single-product-detail product-bundle product-aff">
            <ul class="breadcrumb">
                <li><a href="index.php">Home</a></li>
                <li class="active"><?php echo htmlspecialchars($product['category_name']); ?></li>
                <li class="active"><?php echo htmlspecialchars($product['name']); ?></li>
            </ul>
            <div class="row">
                <div class="col-xs-12 col-sm-6 col-md-6">
                    <div class="flex product-img-slide">
                        <div class="product-images">
                            <div class="main-img js-product-slider">
                                <a href="#" class="hover-images effect">
                                    <img src="<?php echo "..".$primaryImage; ?>" alt="<?php echo htmlspecialchars($product['name']); ?>" class="img-responsive">
                                </a>
                            </div>
                        </div>
                        <div class="multiple-img-list-ver2 js-click-product">
                            <div class="product-col">
                                <div class="img active">
                                    <img src="<?php echo "..".$primaryImage; ?>" alt="<?php echo htmlspecialchars($product['name']); ?>" class="img-responsive">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xs-12 col-sm-6 col-md-6">
                    <div class="single-flex">
                        <div class="single-product-info product-info product-grid-v2 s-50">
                            <p class="product-cate"><?php echo htmlspecialchars($product['category_name']); ?></p>
                            <div class="product-rating">
                                <?php for ($i = 5; $i >= 1; $i--): ?>
                                    <span class="star star-<?php echo $i; ?> <?php echo $i <= round($product['average_rating']) ? 'filled' : ''; ?>"></span>
                                <?php endfor; ?>
                                <div class="number-rating">( <?php echo $product['review_count']; ?> reviews )</div>
                            </div>
                            <h3 class="product-title"><a href="#"><?php echo htmlspecialchars($product['name']); ?></a></h3>
                            <div class="product-price">
                                <span>$<?php echo number_format($product['price'], 2); ?></span>
                            </div>
                            <div class="availability">
                                <p class="product-inventory"> <label>Availability : </label><span><?php echo $product['stock'] > 0 ? 'In stock' : 'Out of stock'; ?></span></p>
                            </div>
                            <div class="product-sku">
                                <label>SKU :</label><span><?php echo htmlspecialchars($product['sku'] ?? 'N/A'); ?></span>
                            </div>
                            <div class="short-desc">
                                <p class="product-desc"><?php echo htmlspecialchars($product['short_description'] ?? 'No description available.'); ?></p>
                                <ul class="desc-list">
                                    <li>Connects directly to Bluetooth</li>
                                    <li>Battery Indicator light</li>
                                    <li>DPI Selection: 2600/2000/1600/1200/800</li>
                                    <li>Computers running Windows</li>
                                </ul>
                            </div>
                            <div class="color-group">
                                <label>Color :</label>
                                <a href="#" class="circle black"></a>
                                <a href="#" class="circle red"></a>
                                <a href="#" class="circle gray"></a>
                            </div>
                            <div class="single-product-button-group">
                                <div class="e-btn cart-qtt btn-gradient">
                                    <div class="e-quantity">
                                        <input type="number" step="1" min="1" max="<?php echo $product['stock'] ?? 999; ?>" name="quantity" value="1" title="Qty" class="qty input-text js-number" size="4">
                                        <div class="tc pa">
                                            <a class="js-plus quantity-right-plus"><i class="fa fa-caret-up"></i></a>
                                            <a class="js-minus quantity-left-minus"><i class="fa fa-caret-down"></i></a>
                                        </div>
                                    </div>
                                    <a href="<?php echo $isAuthenticated ? 'add_to_cart.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-add-cart" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">Add to cart <span class="icon-bg icon-cart v2"></span></a>
                                </div>
                                <a href="<?php echo $isAuthenticated ? 'add_to_cart.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="e-btn btn-icon" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                    <span class="icon-bg icon-wishlist"></span>
                                </a>
                                
                            </div>
                            <div class="product-tags">
                                <label>Tags :</label>
                                <?php
                                $tags = explode(',', $product['tags'] ?? '');
                                foreach ($tags as $tag):
                                    if (trim($tag)):
                                ?>
                                    <a href="#"><?php echo htmlspecialchars(trim($tag)); ?>,</a>
                                <?php endif; endforeach; ?>
                            </div>
                        </div>
                        <div class="single-product-feature s-50 hidden-xs hidden-sm">
                            <div class="bd-7">
                                <div class="single-feature-box">
                                    <div class="single-feature-img">
                                        <img src="img/feature/credit-card2.png" alt="">
                                    </div>
                                    <div class="single-feature-info">
                                        <h3>Safe Payment</h3>
                                        <p>Pay with the world’s most payment methods.</p>
                                    </div>
                                </div>
                                <div class="single-feature-box">
                                    <div class="single-feature-img">
                                        <img src="img/feature/safety2.png" alt="">
                                    </div>
                                    <div class="single-feature-info">
                                        <h3>Confidence</h3>
                                        <p>Protection covers your purchase</p>
                                    </div>
                                </div>
                                <div class="single-feature-box">
                                    <div class="single-feature-img">
                                        <img src="img/feature/truck2.png" alt="">
                                    </div>
                                    <div class="single-feature-info">
                                        <h3>Worldwide Delivery</h3>
                                        <p>Ship to over 200 countries & regions.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="hot-line e-gradient">
                                <p>Hotline</p>
                                <div class="flex align-center tele">
                                    <img src="img/feature/hotline.png" alt="">
                                    <div class="phone-number">
                                        <p>(+123) 456 789</p>
                                        <p>(+123) 666 888</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="single-product-tab bd-7">
                <div class="cmt-title text-center abs">
                    <ul class="nav nav-tabs v3 text-center">
                        <li class="active"><a data-toggle="pill" href="#desc">Description</a></li>
                    </ul>
                </div>
                <div class="tab-content">
                    <div id="desc" class="tab-pane fade in active">
                        <div class="entry-content active">
                            <div class="e-text">
                                <div class="entry-inside v4 text-center">
                                    <img src="img/single/simple_icon.png" alt="">
                                    <h1 class="entry-title spc"><?php echo htmlspecialchars($product['name']); ?></h1>
                                </div>
                                <div class="entry-inside v3">
                                    <div class="lookbook-img text-center image-bd">
                                        <img src="img/single/des_1.jpg" alt="">
                                        <div class="lookbitem" style="left: 63%;top: 30%;">
                                            <div class="lookbitem_btn green">1</div>
                                            <div class="product-info lookbitem_content centerl">
                                                <div class="product-img">
                                                    <a href="#">
                                                        <img class="img-responsive" alt="" src="img/product/pd3.jpg">
                                                    </a>
                                                </div>
                                                <h3 class="product-title">
                                                    <a href="#">HP 22er 21.5-inch LED</a>
                                                </h3>
                                                <div class="product-price">
                                                    <span class="red">$1,450.00</span>
                                                    <span class="old">$1,215.00</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="lookbitem" style="left: 70%;top: 67%;">
                                            <div class="lookbitem_btn pink">2</div>
                                            <div class="product-info lookbitem_content centerr">
                                                <div class="product-img">
                                                    <a href="#">
                                                        <img class="img-responsive" alt="" src="img/product/pd3.jpg">
                                                    </a>
                                                </div>
                                                <h3 class="product-title">
                                                    <a href="#">HP 22er 21.5-inch LED</a>
                                                </h3>
                                                <div class="product-price">
                                                    <span class="red">$1,450.00</span>
                                                    <span class="old">$1,215.00</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="lookbitem" style="left: 55%;top: 91%;">
                                            <div class="lookbitem_btn skyblue">3</div>
                                            <div class="product-info lookbitem_content topl">
                                                <div class="product-img">
                                                    <a href="#">
                                                        <img class="img-responsive" alt="" src="img/product/pd3.jpg">
                                                    </a>
                                                </div>
                                                <h3 class="product-title">
                                                    <a href="#">HP 22er 21.5-inch LED</a>
                                                </h3>
                                                <div class="product-price">
                                                    <span class="red">$1,450.00</span>
                                                    <span class="old">$1,215.00</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="lookbitem" style="left:20%;top:50%;">
                                            <div class="lookbitem_price2 red"><span>$20 - $100</span></div>
                                            <div class="product-info lookbitem_content centerr">
                                                <div class="product-img">
                                                    <a href="#">
                                                        <img class="img-responsive" alt="" src="img/product/pd3.jpg">
                                                    </a>
                                                </div>
                                                <h3 class="product-title">
                                                    <a href="#">HP 22er 21.5-inch LED</a>
                                                </h3>
                                                <div class="product-price">
                                                    <span class="red">$1,450.00</span>
                                                    <span class="old">$1,215.00</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row entry-middle">
                                        <div class="entry-info col-xs-12 col-sm-6 col-md-6">
                                            <h3>Product Overview</h3>
                                            <p><?php echo htmlspecialchars($product['description'] ?? 'No description available.'); ?></p>
                                        </div>
                                        <div class="entry-info col-xs-12 col-sm-6 col-md-6">
                                            <h3>Key Features</h3>
                                            <p><?php echo htmlspecialchars($product['short_description'] ?? 'No key features available.'); ?></p>
                                        </div>
                                    </div>
                                    <div class="text-center image-bd img-cal">
                                        <img src="img/single/des_2.jpg" alt="">
                                    </div>
                                </div>
                            </div>
                            <div class="entry-button text-center abs">
                                <a href="#" class="btn-show">Show more<i class="ion-chevron-down"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="bestseller">
            <div class="ecome-heading style5v3 spc5v3">
                <h1>Related Products</h1>
                <a href="#" class="btn-show">Shop more<i class="ion-ios-arrow-forward"></i></a>
            </div>
            <div class="owl-carousel owl-theme owl-cate v2 js-owl-cate">
                <?php foreach ($relatedProducts as $related): ?>
                    <div class="product-item">
                        <div class="pd-bd product-inner">
                            <div class="product-img">
                                <a href="single_product.php?id=<?php echo $related['product_id']; ?>">
                                    <img src="<?php echo htmlspecialchars("..".$related['primary_image']); ?>" alt="<?php echo htmlspecialchars($related['name']); ?>" class="img-responsive" >
                                </a>
                            </div>
                            <div class="product-info">
                                <div class="color-group"></div>
                                <div class="element-list element-list-left"></div>
                                <div class="element-list element-list-middle">
                                    <p class="product-cate"><?php echo htmlspecialchars($related['category_name']); ?></p>
                                    <h3 class="product-title"><a href="single_product.php?id=<?php echo $related['product_id']; ?>"><?php echo htmlspecialchars($related['name']); ?></a></h3>
                                    <div class="product-bottom">
                                        <div class="product-price"><span>$<?php echo number_format($related['price'], 2); ?></span></div>
                                        <a href="single_product.php?id=<?php echo $related['product_id']; ?>" class="btn-icon btn-view">
                                            <span class="icon-bg icon-view"></span>
                                        </a>
                                    </div>
                                </div>
                                <div class="product-button-group">
                                <a href="<?php echo $isAuthenticated ? 'add_to_cart.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                        <span class="icon-bg icon-cart"></span>
                                    </a>
                                    <a href="<?php echo $isAuthenticated ? 'add_to_wishlist.php?product_id=' . htmlspecialchars($product['product_id']) : '../login.php'; ?>" class="btn-icon" data-product-id="<?php echo htmlspecialchars($product['product_id']); ?>">
                                        <span class="icon-bg icon-wishlist"></span>
                                    </a>
                                    
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="e-category">
            <div class="container container-240">
                <div class="row">
                    <div class="col-xs-12 col-sm-4 col-md-4">
                        <h1 class="cate-title">Featured Products</h1>
                        <?php foreach ($featuredProducts as $featured): ?>
                            <div class="cate-item">
                                <div class="product-img">
                                    <a href="single_product.php?id=<?php echo $featured['product_id']; ?>">
                                        <img src="<?php echo htmlspecialchars("..".$featured['primary_image']); ?>" alt="<?php echo htmlspecialchars($featured['name']); ?>" class="img-responsive">
                                    </a>
                                </div>
                                <div class="product-info">
                                    <h3 class="product-title"><a href="single_product.php?id=<?php echo $featured['product_id']; ?>"><?php echo htmlspecialchars($featured['name']); ?></a></h3>
                                    <div class="product-price v2"><span>$<?php echo number_format($featured['price'], 2); ?></span></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="col-xs-12 col-sm-4 col-md-4">
                        <h1 class="cate-title">Top Rated Products</h1>
                        <?php foreach ($topRatedProducts as $topRated): ?>
                            <div class="cate-item">
                                <div class="product-img">
                                    <a href="single_product.php?id=<?php echo $topRated['product_id']; ?>">
                                        <img src="<?php echo htmlspecialchars("..".$topRated['primary_image']); ?>" alt="<?php echo htmlspecialchars($topRated['name']); ?>" class="img-responsive">
                                    </a>
                                </div>
                                <div class="product-info">
                                    <h3 class="product-title"><a href="single_product.php?id=<?php echo $topRated['product_id']; ?>"><?php echo htmlspecialchars($topRated['name']); ?></a></h3>
                                    <div class="product-price v2"><span>$<?php echo number_format($topRated['price'], 2); ?></span></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="col-xs-12 col-sm-4 col-md-4">
                        <h1 class="cate-title">Top Selling Products</h1>
                        <?php foreach ($topSellingProducts as $topSelling): ?>
                            <div class="cate-item">
                                <div class="product-img">
                                    <a href="single_product.php?id=<?php echo $topSelling['product_id']; ?>">
                                        <img src="<?php echo htmlspecialchars("..".$topSelling['primary_image']); ?>" alt="<?php echo htmlspecialchars($topSelling['name']); ?>" class="img-responsive">
                                    </a>
                                </div>
                                <div class="product-info">
                                    <h3 class="product-title"><a href="single_product.php?id=<?php echo $topSelling['product_id']; ?>"><?php echo htmlspecialchars($topSelling['name']); ?></a></h3>
                                    <div class="product-price v2"><span>$<?php echo number_format($topSelling['price'], 2); ?></span></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
        <!-- ############################3 -->
        <!-- / end content -->

<?php include_once('footer.php'); ?>