<?php
session_start();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Roaming Ndovu | Store</title>
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="shortcut icon" href="../Media/logo.png" type="image/png">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/owl.theme.default.min.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .header-top-banner{
            background-color: green;
        }
    </style>
</head>

<body>
    <?php include_once('header.php'); ?>
    <div class="container container-240">
        <div class="checkout wishlist">
            <ul class="breadcrumb v3">
                <li><a href="./index.php">Home</a></li>
                <li class="active">Wishlist</li>
            </ul>

            <div class="shopping-cart v2 bd-7">
                <div class="cmt-title text-center abs">
                    <h1 class="page-title v4">Wishlist</h1>
                </div>
                <?php if (empty($wishlistItems)): ?>
                    <div class="empty-wishlist-message">
                        <p>Your wishlist is empty. <a href="index.php">Start adding items now!</a></p>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table cart-table">
                            <tbody>
                            
                                <?php foreach ($wishlistItems as $item): ?>
                                    <tr class="item_cart">
                                        <td class="product-name flex align-center">
                                            <a href="remove_from_wishlist.php?wishlist_id=<?php echo htmlspecialchars($item['wishlist_id']); ?>" class="btn-del"><i class="ion-ios-close-empty"></i></a>
                                            <div class="product-img">
                                                <img src="<?php echo "../".htmlspecialchars($item['primary_image']); ?>" alt="<?php echo htmlspecialchars($item['name']); ?>">
                                            </div>
                                            <div class="product-info">
                                                <a href="single_product.php?id=<?php echo htmlspecialchars($item['product_id']); ?>" title=""><?php echo htmlspecialchars($item['name']); ?></a>
                                            </div>
                                        </td>
                                        <td class="total-price">
                                            <p class="price">$<?php echo number_format($item['price'], 2); ?></p>
                                        </td>
                                        <td class="w-status">
                                            <p><?php echo $product['stock'] > 0 ? 'In stock' : 'Out of stock'; ?></p>
                                        </td>
                                        <td class="w-button">
                                            <a href="add_to_cart.php?product_id=<?php echo htmlspecialchars($item['product_id']); ?>" class="btn-addcart btn-gradient">Add to cart</a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

   <?php include_once('footer.php'); ?>