<?php
require_once "../backend/config/database.php";
// Pagination settings
$perPageOptions = [12, 24, 36, 48];
$perPage = isset($_GET['per_page']) && in_array((int)$_GET['per_page'], $perPageOptions) ? (int)$_GET['per_page'] : 12;
$page = isset($_GET['page']) && is_numeric($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $perPage;
// Fetch data
$db = new DatabaseConfig();
$conn = $db->getConnection();

// Fetch total product count for pagination
$totalStmt = $conn->query("SELECT COUNT(*) FROM products WHERE is_active = 1");
$totalProducts = $totalStmt->fetchColumn();
$totalPages = ceil($totalProducts / $perPage);

// Fetch products
$productsStmt = $conn->prepare("
    SELECT p.*, c.name AS category_name
    FROM products p
    LEFT JOIN categories c ON p.category_id = c.category_id
    WHERE p.is_active = 1
    LIMIT :limit OFFSET :offset
");
$productsStmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
$productsStmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$productsStmt->execute();
$products = $productsStmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />
    <title>Roaming Ndovu | Store</title>
    <link rel="stylesheet" href="css/owl.carousel.min.css">
    <link rel="shortcut icon" href="../Media/logo.png" type="image/png">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/owl.theme.default.min.css">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        .header-top-banner{
            background-color: green;
        }
        /* Uniform image sizing for product images */
        .product-img img {
            width: 200px; /* Fixed width */
            height: 200px; /* Fixed height */
            object-fit: cover; /* Crops the image to fill the container while preserving aspect ratio */
            display: block; /* Ensures no extra space below the image */
            margin: 0 auto; /* Centers the image horizontally */
        }

        /* Ensure responsiveness while maintaining uniformity */
        @media (max-width: 767px) {
            .product-img img {
                width: 150px; /* Smaller size for mobile devices */
                height: 150px;
            }
        }

        /* Additional styling for featured/top-rated/top-selling sections */
        .e-category .product-img img {
            width: 200px; /* Uniform size for category section images */
            height: 200px;
            object-fit: cover;
            display: block;
            margin: 0 auto;
        }

        @media (max-width: 767px) {
            .e-category .product-img img {
                width: 150px; /* Smaller size for mobile devices */
                height: 150px;
            }
        }
    </style>
</head>


<?php include "./header.php"; ?>


        <!-- /header -->
<!-- ##################################################### -->

<!--content-->
<div class="container container-240">
        <div class="e-product">
            <ul class="breadcrumb v4">
                <li><a href="#">Home</a></li>
                <li class="active">Shop</li>
            </ul>
            <div class="pd-banner">
                <a href="#" class="image-bd effect_img2"><img src="img/shop-banner.jpg" alt="" class="img-reponsive"></a> 
            </div>
            <div class="pd-top">
                <h1 class="title">Shop</h1>
                <div class="show-element"><span>Showing <?php echo ($offset + 1) . '–' . min($offset + $perPage, $totalProducts) . ' of ' . $totalProducts . ' results'; ?></span></div>
            </div>
            <div class="pd-middle">
                <div class="view-mode view-group">
                    <a class="grid-icon col active"><img src="img/grid.png" alt=""></a>
                    <a class="grid-icon col2"><img src="img/grid2.png" alt=""></a>
                    <a class="list-icon list"><img src="img/list.png" alt=""></a>
                </div>
                <div class="pd-sort">
                    <div class="filter-sort">
                        <div class="dropdown">
                            <button class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                <span class="dropdown-label">Default sorting</span>
                            </button>
                            <ul class="dropdown-menu">
       
                            <li><a href="?sort=manual">Featured</a></li>   
                                <li><a href="?sort=best-selling">Best Selling</a></li>
                                <li><a href="?sort=title-ascending">Alphabetically, A-Z</a></li>
                                <li><a href="?sort=title-descending">Alphabetically, Z-A</a></li>
                                <li><a href="?sort=price-descending">Price, high to low</a></li>
                                <li><a href="?sort=price-ascending">Price, low to high</a></li>
                                <li><a href="?sort=created-ascending">Date, old to new</a></li>
                                <li><a href="?sort=created-descending">Date, new to old</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="filter-show">
                        <div class="dropdown">
                            <button class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                Show
                                <span class="dropdown-label"><?php echo $perPage; ?></span>
                            </button>
                            <ul class="dropdown-menu">
                                <?php foreach ($perPageOptions as $option): ?>
                                    <li><a href="?per_page=<?php echo $option; ?>&page=1"><?php echo $option; ?></a></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="product-collection-grid product-grid spc1">
                <div class="row">
                    <?php foreach ($products as $product): 
                        // Generate random multiplier for old_price
                        $multiplier = mt_rand(101999, 1999999) / 1000000; // Between 1.01999 and 1.999999
                        $old_price = $product['price'] * $multiplier;
                    ?>
                        <div class="col-xs-6 col-sm-4 col-md-4 col-lg-3 product-item">
                            <div class="pd-bd product-inner">
                                <div class="product-img">
                                    <a href="single_product.php?id=<?php echo $product['product_id']; ?>">
                                        <img src="<?php echo htmlspecialchars("..".$product['primary_image'] ?? 'img/product/default.jpg'); ?>" alt="<?php echo htmlspecialchars($product['name']); ?>" class="img-reponsive">
                                    </a>
                                    <?php if ($old_price > $product['price']): ?>
                                        <div class="ribbon-price red"><span>- <?php echo round((($old_price - $product['price']) / $old_price) * 100); ?>% </span></div>
                                    <?php endif; ?>
                                </div>
                                <div class="product-info">
                                    <div class="color-group">
                                        <!-- Add color options if available -->
                                    </div>
                                    <div class="element-list element-list-left">
                                        <ul class="desc-list">
                                            <li>Connects directly to Bluetooth</li>
                                            <li>Battery Indicator light</li>
                                            <li>DPI Selection: 2600/2000/1600/1200/800</li>
                                            <li>Computers running Windows</li>
                                        </ul>
                                    </div>
                                    <div class="element-list element-list-middle">
                                        <p class="product-cate"><?php echo htmlspecialchars($product['category_name'] ?? 'Uncategorized'); ?></p>
                                        <h3 class="product-title"><a href="single_product.php?id=<?php echo $product['product_id']; ?>"><?php echo htmlspecialchars($product['name']); ?></a></h3>
                                        <div class="product-bottom">
                                            <div class="product-price">
                                                <span class="red">$<?php echo number_format($product['price'], 2); ?></span>
                                                <?php if ($old_price > $product['price']): ?>
                                                    <span class="old">$<?php echo number_format($old_price, 2); ?></span>
                                                <?php endif; ?>
                                            </div>
                                            <a href="single_product.php?id=<?php echo $product['product_id']; ?>" class="btn-icon btn-view">
                                                <span class="icon-bg icon-view"></span>
                                            </a>
                                            
                                        </div>
                                        <style>
                                            .icon-container {
                                                    display: flex; /* Aligns children (icons) in a row */
                                                    gap: 10px; /* Adds spacing between icons */
                                                }

                                                .btn-icon {
                                                    text-decoration: none; /* Removes default underline from links */
                                                }

                                                /* Optional: Style the icon background if needed */
                                                .icon-bg {
                                                    display: inline-block; /* Ensures the span behaves like an inline element */
                                                    width:25px; /* Adjust size as needed */
                                                    height: 24px; /* Adjust size as needed */
                                                    background-size: cover; /* Ensures the icon fits the container */
                                                }

                                                
                                        </style>
                                        <div class="icon-container">
                                            <a href="#" class="btn-icon">
                                                <span class="icon-bg icon-cart"></span>
                                            </a>
                                            <a href="#" class="btn-icon">
                                                <span class="icon-bg icon-wishlist"></span>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="pd-middle space-v1">
                <ul class="pagination">
                    <?php for ($i = 1; $i <= $totalPages; $i++): ?>
                        <li class="<?php echo $i == $page ? 'active' : ''; ?>">
                            <a href="?page=<?php echo $i; ?>&per_page=<?php echo $perPage; ?>"><?php echo $i; ?></a>
                        </li>
                    <?php endfor; ?>
                    <?php if ($page < $totalPages): ?>
                        <li><a href="?page=<?php echo $page + 1; ?>&per_page=<?php echo $perPage; ?>"><i class="ion-ios-arrow-forward"></i></a></li>
                    <?php endif; ?>
                </ul>
                <div class="pd-sort">
                    <div class="filter-sort">
                        <div class="dropdown">
                            <button class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                <span class="dropdown-label">Default sorting</span>
                            </button>
                            <ul class="dropdown-menu">
                                <li><a href="?sort=manual">Featured</a></li>   
                                <li><a href="?sort=best-selling">Best Selling</a></li>
                                <li><a href="?sort=title-ascending">Alphabetically, A-Z</a></li>
                                <li><a href="?sort=title-descending">Alphabetically, Z-A</a></li>
                                <li><a href="?sort=price-descending">Price, high to low</a></li>
                                <li><a href="?sort=price-ascending">Price, low to high</a></li>
                                <li><a href="?sort=created-ascending">Date, old to new</a></li>
                                <li><a href="?sort=created-descending">Date, new to old</a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="filter-show">
                        <div class="dropdown">
                            <button class="dropdown-toggle" data-toggle="dropdown" aria-expanded="false">
                                Show
                                <span class="dropdown-label"><?php echo $perPage; ?></span>
                            </button>
                            <ul class="dropdown-menu">
                                <?php foreach ($perPageOptions as $option): ?>
                                    <li><a href="?per_page=<?php echo $option; ?>&page=1"><?php echo $option; ?></a></li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



<!-- ################################################################## -->
        <footer>
            <div class="f-top">
                <div class="container container-240">
                    <div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-3 col-lg-3">
                            <div class="footer-block footer-about">
                                
                                <ul class="footer-block-content">
                                    <li class="address">
                                        <span>Nairobi, Kenya</span>
                                    </li>
                                    <li class="phone">
                                        <span>(+123) 456 789 - (+123) 666 888</span>
                                    </li>
                                    <li class="email">
                                        <span>roamingndovu@gmail.com</span>
                                    </li>
                                    <li class="time">
                                        <span>24/7 service</span>
                                    </li>
                                </ul>
                                <div class="footer-social social">
                                    <h3 class="footer-block-title">Follow us</h3>
                                    <a href="#" class="fab fa-twitter"></a>
                                    <a href="#" class="fab fa-facebook"></a>
                                    <a href="#" class="fab fa-tiktok"></a>
                                    <a href="#" class="fab fa-instagram"></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-3 col-lg-3">
                            <div class="footer-block">
                                <h3 class="footer-block-title">Quick menu</h3>
                                <ul class="footer-block-content">
                                    <li><a href="#">TV & Video</a></li>
                                    <li><a href="#">Home Audio & Theater</a></li>
                                    <li><a href="#">Camera, Photo & Video</a></li>
                                    <li><a href="#">Cell Phones & Accessories</a></li>
                                    <li><a href="#">Headphones</a></li>
                                    <li><a href="#">Video Games</a></li>
                                    <li><a href="#">Bluetooth & Wireless Speakers</a></li>
                                    <li><a href="#">Car Electronics</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-xs-6 col-sm-6 col-md-2 col-lg-2">
                            <div class="footer-block">
                                <h3 class="footer-block-title">Customer Service</h3>
                                <ul class="footer-block-content">
                                    <li><a href="#">My Account</a></li>
                                    <li><a href="#">Track your Order</a></li>
                                    <li><a href="#">Returns/Exchange</a></li>
                                    <li><a href="#">FAQs</a></li>
                                    <li><a href="#">Customer Service</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-4 col-lg-4">
                            <div class="footer-block">
                                <div class="footer-block-phone">
                                    <h3 class="footer-block-title">Company</h3>
                                    <p class="phone-desc">About</p>
                                    <p class="phone-desc">Blog</p>
                                    <p class="phone-desc">Home</p>
                                    <p class="phone-desc">Get Card</p>
                                    <p class="phone-desc">Support</p>


                                    <!-- <p class="phone-light">(+123) 456 789 or (+123) 666 888</p> -->
                                </div>
                               
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="f-bottom">
                <div class="container container-240">
                    <div class="row flex lr">
                        <div class="col-xs-6 f-copyright"><span  style="color: white;">© RoamingNdovu | All rights reserved.</span></div>
                        <div class="col-xs-6 f-payment hidden-xs">
                            
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <!-- /footer -->
        <!-- /footer -->
    </div>
    
    <script src="js/jquery.js"></script>
    <script src="js/bootstrap.js"></script>
    <script src="js/owl.carousel.min.js"></script>
    <script src="js/slick.min.js"></script>
    
    <script src="js/main.js"></script>
</body>

</html>